/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.observer;

import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.CancelableStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.ServerStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.call.ServerCall;

public class ServerCallToObserverAdapter<T>
extends CancelableStreamObserver<T>
implements ServerStreamObserver<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelableStreamObserver.class);
    public final CancellationContext cancellationContext;
    private final ServerCall call;
    private Map<String, Object> attachments;
    private boolean terminated = false;

    public ServerCallToObserverAdapter(ServerCall call, CancellationContext cancellationContext) {
        this.call = call;
        this.cancellationContext = cancellationContext;
    }

    public boolean isAutoRequestN() {
        return this.call.isAutoRequestN();
    }

    private boolean isTerminated() {
        return this.terminated;
    }

    private void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void onNext(Object data) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Stream observer has been terminated, no more data is allowed");
        }
        this.call.writeMessage(data);
    }

    public void onError(Throwable throwable) {
        TriRpcStatus status = TriRpcStatus.getStatus((Throwable)throwable);
        this.onCompleted(status);
    }

    public void onCompleted(TriRpcStatus status) {
        if (this.isTerminated()) {
            return;
        }
        this.call.close(status, this.attachments);
        this.setTerminated(true);
    }

    public void onCompleted() {
        if (this.isTerminated()) {
            return;
        }
        this.call.close(TriRpcStatus.OK, this.attachments);
        this.setTerminated(true);
    }

    public void setResponseAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void setCompression(String compression) {
        this.call.setCompression(compression);
    }

    @Override
    public void cancel(Throwable throwable) {
        this.cancellationContext.cancel(throwable);
    }

    public boolean isTimeout(long cost) {
        return this.call.timeout != null && this.call.timeout < cost;
    }

    @Override
    public void disableAutoInboundFlowControl() {
        this.call.disableAutoRequestN();
    }

    @Override
    public void request(int count) {
        this.call.requestN(count);
    }
}

