/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.formats.avro.utils.MutableByteArrayInputStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

@PublicEvolving
public class AvroRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final int MILLIS_PER_DAY = 86400000;
    private final RowType rowType;
    private final TypeInformation<RowData> typeInfo;
    private final DeserializationRuntimeConverter runtimeConverter;
    private transient IndexedRecord record;
    private transient DatumReader<IndexedRecord> datumReader;
    private transient MutableByteArrayInputStream inputStream;
    private transient Decoder decoder;

    public AvroRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> typeInfo) {
        this.rowType = rowType;
        this.typeInfo = typeInfo;
        this.runtimeConverter = AvroRowDataDeserializationSchema.createRowConverter(rowType);
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)this.rowType);
        this.record = new GenericData.Record(schema);
        this.datumReader = new SpecificDatumReader(schema);
        this.inputStream = new MutableByteArrayInputStream();
        this.decoder = DecoderFactory.get().binaryDecoder((InputStream)this.inputStream, null);
    }

    public RowData deserialize(byte[] message) throws IOException {
        try {
            this.inputStream.setBuffer(message);
            this.record = (IndexedRecord)this.datumReader.read((Object)this.record, this.decoder);
            return (RowData)this.runtimeConverter.convert(this.record);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize Avro record.", e);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRowDataDeserializationSchema that = (AvroRowDataDeserializationSchema)o;
        return Objects.equals(this.rowType, that.rowType) && Objects.equals(this.typeInfo, that.typeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.rowType, this.typeInfo);
    }

    static DeserializationRuntimeConverter createRowConverter(RowType rowType) {
        DeserializationRuntimeConverter[] fieldConverters = (DeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(AvroRowDataDeserializationSchema::createNullableConverter).toArray(DeserializationRuntimeConverter[]::new);
        int arity = rowType.getFieldCount();
        return avroObject -> {
            IndexedRecord record = (IndexedRecord)avroObject;
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                row.setField(i, fieldConverters[i].convert(record.get(i)));
            }
            return row;
        };
    }

    private static DeserializationRuntimeConverter createNullableConverter(LogicalType type) {
        DeserializationRuntimeConverter converter = AvroRowDataDeserializationSchema.createConverter(type);
        return avroObject -> {
            if (avroObject == null) {
                return null;
            }
            return converter.convert(avroObject);
        };
    }

    private static DeserializationRuntimeConverter createConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return avroObject -> null;
            }
            case TINYINT: {
                return avroObject -> ((Integer)avroObject).byteValue();
            }
            case SMALLINT: {
                return avroObject -> ((Integer)avroObject).shortValue();
            }
            case BOOLEAN: 
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: {
                return avroObject -> avroObject;
            }
            case DATE: {
                return AvroRowDataDeserializationSchema::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return AvroRowDataDeserializationSchema::convertToTime;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return AvroRowDataDeserializationSchema::convertToTimestamp;
            }
            case CHAR: 
            case VARCHAR: {
                return avroObject -> StringData.fromString((String)avroObject.toString());
            }
            case BINARY: 
            case VARBINARY: {
                return AvroRowDataDeserializationSchema::convertToBytes;
            }
            case DECIMAL: {
                return AvroRowDataDeserializationSchema.createDecimalConverter((DecimalType)type);
            }
            case ARRAY: {
                return AvroRowDataDeserializationSchema.createArrayConverter((ArrayType)type);
            }
            case ROW: {
                return AvroRowDataDeserializationSchema.createRowConverter((RowType)type);
            }
            case MAP: 
            case MULTISET: {
                return AvroRowDataDeserializationSchema.createMapConverter(type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static DeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return avroObject -> {
            byte[] bytes;
            if (avroObject instanceof GenericFixed) {
                bytes = ((GenericFixed)avroObject).bytes();
            } else if (avroObject instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)avroObject;
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
            } else {
                bytes = (byte[])avroObject;
            }
            return DecimalData.fromUnscaledBytes((byte[])bytes, (int)precision, (int)scale);
        };
    }

    private static DeserializationRuntimeConverter createArrayConverter(ArrayType arrayType) {
        DeserializationRuntimeConverter elementConverter = AvroRowDataDeserializationSchema.createNullableConverter(arrayType.getElementType());
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        return avroObject -> {
            List list = (List)avroObject;
            int length = list.size();
            Object[] array = (Object[])Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = elementConverter.convert(list.get(i));
            }
            return new GenericArrayData(array);
        };
    }

    private static DeserializationRuntimeConverter createMapConverter(LogicalType type) {
        DeserializationRuntimeConverter keyConverter = AvroRowDataDeserializationSchema.createConverter(DataTypes.STRING().getLogicalType());
        DeserializationRuntimeConverter valueConverter = AvroRowDataDeserializationSchema.createConverter(AvroSchemaConverter.extractValueTypeToAvroMap(type));
        return avroObject -> {
            Map map = (Map)avroObject;
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Object key = keyConverter.convert(entry.getKey());
                Object value = valueConverter.convert(entry.getValue());
                result.put(key, value);
            }
            return new GenericMapData(result);
        };
    }

    private static TimestampData convertToTimestamp(Object object) {
        long millis;
        if (object instanceof Long) {
            millis = (Long)object;
        } else {
            DateTime value = (DateTime)object;
            millis = value.toDate().getTime();
        }
        return AvroRowDataDeserializationSchema.toTimestampData(millis);
    }

    private static int convertToDate(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        LocalDate value = (LocalDate)object;
        return (int)(AvroRowDataDeserializationSchema.toTimestampData(value.toDate().getTime()).getMillisecond() / 86400000L);
    }

    private static TimestampData toTimestampData(long timeZoneMills) {
        return TimestampData.fromTimestamp((Timestamp)new Timestamp(timeZoneMills));
    }

    private static int convertToTime(Object object) {
        int millis;
        if (object instanceof Integer) {
            millis = (Integer)object;
        } else {
            LocalTime value = (LocalTime)object;
            millis = value.get(DateTimeFieldType.millisOfDay());
        }
        return millis;
    }

    private static byte[] convertToBytes(Object object) {
        if (object instanceof GenericFixed) {
            return ((GenericFixed)object).bytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return (byte[])object;
    }

    @FunctionalInterface
    static interface DeserializationRuntimeConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

