/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class AvroRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final SerializationRuntimeConverter runtimeConverter;
    private transient Schema schema;
    private transient DatumWriter<IndexedRecord> datumWriter;
    private transient ByteArrayOutputStream arrayOutputStream;
    private transient Encoder encoder;

    public AvroRowDataSerializationSchema(RowType rowType) {
        this.rowType = (RowType)Preconditions.checkNotNull((Object)rowType, (String)"RowType cannot be null.");
        this.runtimeConverter = AvroRowDataSerializationSchema.createRowConverter(rowType);
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.schema = AvroSchemaConverter.convertToSchema((LogicalType)this.rowType);
        this.datumWriter = new SpecificDatumWriter(this.schema);
        this.arrayOutputStream = new ByteArrayOutputStream();
        this.encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.arrayOutputStream, null);
    }

    public byte[] serialize(RowData row) {
        try {
            GenericRecord record = (GenericRecord)this.runtimeConverter.convert(this.schema, row);
            this.arrayOutputStream.reset();
            this.datumWriter.write((Object)record, this.encoder);
            this.encoder.flush();
            return this.arrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize row.", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroRowDataSerializationSchema that = (AvroRowDataSerializationSchema)o;
        return Objects.equals(this.rowType, that.rowType);
    }

    public int hashCode() {
        return Objects.hash(this.rowType);
    }

    static SerializationRuntimeConverter createRowConverter(RowType rowType) {
        SerializationRuntimeConverter[] fieldConverters = (SerializationRuntimeConverter[])rowType.getChildren().stream().map(AvroRowDataSerializationSchema::createConverter).toArray(SerializationRuntimeConverter[]::new);
        LogicalType[] fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)fieldTypes[i], (int)i);
        }
        int length = rowType.getFieldCount();
        return (schema, object) -> {
            RowData row = (RowData)object;
            List fields = schema.getFields();
            GenericData.Record record = new GenericData.Record(schema);
            for (int i = 0; i < length; ++i) {
                Schema.Field schemaField = (Schema.Field)fields.get(i);
                Object avroObject = fieldConverters[i].convert(schemaField.schema(), fieldGetters[i].getFieldOrNull(row));
                record.put(i, avroObject);
            }
            return record;
        };
    }

    private static SerializationRuntimeConverter createConverter(LogicalType type) {
        SerializationRuntimeConverter converter;
        switch (type.getTypeRoot()) {
            case NULL: {
                converter = (schema, object) -> null;
                break;
            }
            case TINYINT: {
                converter = (schema, object) -> ((Byte)object).intValue();
                break;
            }
            case SMALLINT: {
                converter = (schema, object) -> ((Short)object).intValue();
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: {
                converter = (schema, object) -> object;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                converter = (schema, object) -> new Utf8(object.toString());
                break;
            }
            case BINARY: 
            case VARBINARY: {
                converter = (schema, object) -> ByteBuffer.wrap((byte[])object);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                converter = (schema, object) -> ((TimestampData)object).toTimestamp().getTime();
                break;
            }
            case DECIMAL: {
                converter = (schema, object) -> ByteBuffer.wrap(((DecimalData)object).toUnscaledBytes());
                break;
            }
            case ARRAY: {
                converter = AvroRowDataSerializationSchema.createArrayConverter((ArrayType)type);
                break;
            }
            case ROW: {
                converter = AvroRowDataSerializationSchema.createRowConverter((RowType)type);
                break;
            }
            case MAP: 
            case MULTISET: {
                converter = AvroRowDataSerializationSchema.createMapConverter(type);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
        }
        return (schema, object) -> {
            Schema actualSchema;
            if (object == null) {
                return null;
            }
            if (schema.getType() == Schema.Type.UNION) {
                List types = schema.getTypes();
                int size = types.size();
                if (size == 2 && ((Schema)types.get(1)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)types.get(0);
                    return converter.convert(actualSchema, object);
                } else {
                    if (size != 2 || ((Schema)types.get(0)).getType() != Schema.Type.NULL) throw new IllegalArgumentException("The Avro schema is not a nullable type: " + schema.toString());
                    actualSchema = (Schema)types.get(1);
                }
                return converter.convert(actualSchema, object);
            } else {
                actualSchema = schema;
            }
            return converter.convert(actualSchema, object);
        };
    }

    private static SerializationRuntimeConverter createArrayConverter(ArrayType arrayType) {
        LogicalType elementType = arrayType.getElementType();
        ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter((LogicalType)elementType);
        SerializationRuntimeConverter elementConverter = AvroRowDataSerializationSchema.createConverter(arrayType.getElementType());
        return (schema, object) -> {
            Schema elementSchema = schema.getElementType();
            ArrayData arrayData = (ArrayData)object;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < arrayData.size(); ++i) {
                list.add(elementConverter.convert(elementSchema, elementGetter.getElementOrNull(arrayData, i)));
            }
            return list;
        };
    }

    private static SerializationRuntimeConverter createMapConverter(LogicalType type) {
        LogicalType valueType = AvroSchemaConverter.extractValueTypeToAvroMap(type);
        ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        SerializationRuntimeConverter valueConverter = AvroRowDataSerializationSchema.createConverter(valueType);
        return (schema, object) -> {
            Schema valueSchema = schema.getValueType();
            MapData mapData = (MapData)object;
            ArrayData keyArray = mapData.keyArray();
            ArrayData valueArray = mapData.valueArray();
            HashMap<String, Object> map = new HashMap<String, Object>(mapData.size());
            for (int i = 0; i < mapData.size(); ++i) {
                String key = keyArray.getString(i).toString();
                Object value = valueConverter.convert(valueSchema, valueGetter.getElementOrNull(valueArray, i));
                map.put(key, value);
            }
            return map;
        };
    }

    static interface SerializationRuntimeConverter
    extends Serializable {
        public Object convert(Schema var1, Object var2);
    }
}

