/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaParseException;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class AvroSchemaConverter {
    private AvroSchemaConverter() {
    }

    public static <T extends SpecificRecord> TypeInformation<Row> convertToTypeInfo(Class<T> avroClass) {
        Preconditions.checkNotNull(avroClass, (String)"Avro specific record class must not be null.");
        Schema schema = SpecificData.get().getSchema(avroClass);
        return AvroSchemaConverter.convertToTypeInfo(schema);
    }

    public static <T> TypeInformation<T> convertToTypeInfo(String avroSchemaString) {
        Schema schema;
        Preconditions.checkNotNull((Object)avroSchemaString, (String)"Avro schema must not be null.");
        try {
            schema = new Schema.Parser().parse(avroSchemaString);
        }
        catch (SchemaParseException e) {
            throw new IllegalArgumentException("Could not parse Avro schema string.", e);
        }
        return AvroSchemaConverter.convertToTypeInfo(schema);
    }

    private static TypeInformation<?> convertToTypeInfo(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                List fields = schema.getFields();
                TypeInformation[] types = new TypeInformation[fields.size()];
                String[] names = new String[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field = (Schema.Field)fields.get(i);
                    types[i] = AvroSchemaConverter.convertToTypeInfo(field.schema());
                    names[i] = field.name();
                }
                return Types.ROW_NAMED((String[])names, (TypeInformation[])types);
            }
            case ENUM: {
                return Types.STRING;
            }
            case ARRAY: {
                return Types.OBJECT_ARRAY(AvroSchemaConverter.convertToTypeInfo(schema.getElementType()));
            }
            case MAP: {
                return Types.MAP((TypeInformation)Types.STRING, AvroSchemaConverter.convertToTypeInfo(schema.getValueType()));
            }
            case UNION: {
                Schema actualSchema;
                if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)schema.getTypes().get(1);
                } else if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                } else if (schema.getTypes().size() == 1) {
                    actualSchema = (Schema)schema.getTypes().get(0);
                } else {
                    return Types.GENERIC(Object.class);
                }
                return AvroSchemaConverter.convertToTypeInfo(actualSchema);
            }
            case FIXED: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return Types.BIG_DEC;
                }
                return Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE);
            }
            case STRING: {
                return Types.STRING;
            }
            case BYTES: {
                if (schema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return Types.BIG_DEC;
                }
                return Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE);
            }
            case INT: {
                LogicalType logicalType = schema.getLogicalType();
                if (logicalType == LogicalTypes.date()) {
                    return Types.SQL_DATE;
                }
                if (logicalType == LogicalTypes.timeMillis()) {
                    return Types.SQL_TIME;
                }
                return Types.INT;
            }
            case LONG: {
                if (schema.getLogicalType() == LogicalTypes.timestampMillis()) {
                    return Types.SQL_TIMESTAMP;
                }
                return Types.LONG;
            }
            case FLOAT: {
                return Types.FLOAT;
            }
            case DOUBLE: {
                return Types.DOUBLE;
            }
            case BOOLEAN: {
                return Types.BOOLEAN;
            }
            case NULL: {
                return Types.VOID;
            }
        }
        throw new IllegalArgumentException("Unsupported Avro type '" + schema.getType() + "'.");
    }

    public static Schema convertToSchema(org.apache.flink.table.types.logical.LogicalType logicalType) {
        return AvroSchemaConverter.convertToSchema(logicalType, 0);
    }

    public static Schema convertToSchema(org.apache.flink.table.types.logical.LogicalType logicalType, int rowTypeCounter) {
        switch (logicalType.getTypeRoot()) {
            case NULL: {
                return (Schema)SchemaBuilder.builder().nullType();
            }
            case BOOLEAN: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).booleanType();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).intType();
            }
            case BIGINT: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).longType();
            }
            case FLOAT: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).floatType();
            }
            case DOUBLE: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).doubleType();
            }
            case CHAR: 
            case VARCHAR: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).stringType();
            }
            case BINARY: 
            case VARBINARY: {
                return (Schema)AvroSchemaConverter.getNullableBuilder(logicalType).bytesType();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)logicalType;
                int precision = timestampType.getPrecision();
                if (precision > 3) {
                    throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only supports precision less than 3.");
                }
                LogicalTypes.TimestampMillis avroLogicalType = LogicalTypes.timestampMillis();
                return avroLogicalType.addToSchema((Schema)SchemaBuilder.builder().longType());
            }
            case DATE: {
                return LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType());
            }
            case TIME_WITHOUT_TIME_ZONE: {
                int precision = ((TimeType)logicalType).getPrecision();
                if (precision > 3) {
                    throw new IllegalArgumentException("Avro does not support TIME type with precision: " + precision + ", it only supports precision less than 3.");
                }
                return LogicalTypes.timeMillis().addToSchema((Schema)SchemaBuilder.builder().intType());
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return LogicalTypes.decimal((int)decimalType.getPrecision(), (int)decimalType.getScale()).addToSchema((Schema)SchemaBuilder.builder().bytesType());
            }
            case ROW: {
                RowType rowType = (RowType)logicalType;
                List fieldNames = rowType.getFieldNames();
                SchemaBuilder.FieldAssembler builder = SchemaBuilder.builder().record("row_" + rowTypeCounter).fields();
                ++rowTypeCounter;
                for (int i = 0; i < rowType.getFieldCount(); ++i) {
                    builder = builder.name((String)fieldNames.get(i)).type(AvroSchemaConverter.convertToSchema(rowType.getTypeAt(i), rowTypeCounter)).noDefault();
                }
                return (Schema)builder.endRecord();
            }
            case MULTISET: 
            case MAP: {
                return (Schema)SchemaBuilder.builder().nullable().map().values(AvroSchemaConverter.convertToSchema(AvroSchemaConverter.extractValueTypeToAvroMap(logicalType), rowTypeCounter));
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                return (Schema)SchemaBuilder.builder().nullable().array().items(AvroSchemaConverter.convertToSchema(arrayType.getElementType(), rowTypeCounter));
            }
        }
        throw new UnsupportedOperationException("Unsupported to derive Schema for type: " + logicalType);
    }

    public static org.apache.flink.table.types.logical.LogicalType extractValueTypeToAvroMap(org.apache.flink.table.types.logical.LogicalType type) {
        org.apache.flink.table.types.logical.LogicalType valueType;
        org.apache.flink.table.types.logical.LogicalType keyType;
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            keyType = mapType.getKeyType();
            valueType = mapType.getValueType();
        } else {
            MultisetType multisetType = (MultisetType)type;
            keyType = multisetType.getElementType();
            valueType = new IntType();
        }
        if (!LogicalTypeChecks.hasFamily((org.apache.flink.table.types.logical.LogicalType)keyType, (LogicalTypeFamily)LogicalTypeFamily.CHARACTER_STRING)) {
            throw new UnsupportedOperationException("Avro format doesn't support non-string as key type of map. The key type is: " + keyType.asSummaryString());
        }
        return valueType;
    }

    private static SchemaBuilder.BaseTypeBuilder<Schema> getNullableBuilder(org.apache.flink.table.types.logical.LogicalType logicalType) {
        SchemaBuilder.TypeBuilder builder = SchemaBuilder.builder();
        if (logicalType.isNullable()) {
            return builder.nullable();
        }
        return builder;
    }
}

