/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.flink.annotation.VisibleForTesting;

class JarManifestParser {
    JarManifestParser() {
    }

    static JarFileWithEntryClass findOnlyEntryClass(Iterable<File> jarFiles) throws IOException {
        ArrayList jarsWithEntryClasses = new ArrayList();
        for (File jarFile : jarFiles) {
            JarManifestParser.findEntryClass(jarFile).ifPresent(entryClass -> jarsWithEntryClasses.add(new JarFileWithEntryClass(jarFile, (String)entryClass)));
        }
        int size = jarsWithEntryClasses.size();
        if (size == 0) {
            throw new NoSuchElementException("No JAR with manifest attribute for entry class");
        }
        if (size == 1) {
            return (JarFileWithEntryClass)jarsWithEntryClasses.get(0);
        }
        throw new IllegalArgumentException("Multiple JARs with manifest attribute for entry class: " + jarsWithEntryClasses);
    }

    @VisibleForTesting
    static Optional<String> findEntryClass(File jarFile) throws IOException {
        return JarManifestParser.findFirstManifestAttribute(jarFile, "program-class", "Main-Class");
    }

    private static Optional<String> findFirstManifestAttribute(File jarFile, String ... attributes) throws IOException {
        if (attributes.length == 0) {
            return Optional.empty();
        }
        try (JarFile f = new JarFile(jarFile);){
            Optional<String> optional = JarManifestParser.findFirstManifestAttribute(f, attributes);
            return optional;
        }
    }

    private static Optional<String> findFirstManifestAttribute(JarFile jarFile, String ... attributes) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return Optional.empty();
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        for (String attribute : attributes) {
            String value = mainAttributes.getValue(attribute);
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    static class JarFileWithEntryClass {
        private final File jarFile;
        private final String entryClass;

        private JarFileWithEntryClass(File jarFile, String entryClass) {
            this.jarFile = Objects.requireNonNull(jarFile, "jarFile");
            this.entryClass = Objects.requireNonNull(entryClass, "entryClass");
        }

        File getJarFile() {
            return this.jarFile;
        }

        String getEntryClass() {
            return this.entryClass;
        }

        public String toString() {
            return String.format("%s (entry class: %s)", this.jarFile.getAbsolutePath(), this.entryClass);
        }
    }
}

