/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public abstract class ProgramOptions
extends CommandLineOptions {
    private final String jarFilePath;
    private final String entryPointClass;
    private final List<URL> classpaths;
    private final String[] programArgs;
    private final int parallelism;
    private final boolean stdoutLogging;
    private final boolean detachedMode;
    private final SavepointRestoreSettings savepointSettings;

    protected ProgramOptions(CommandLine line) throws CliArgsException {
        block12: {
            String[] args;
            super(line);
            String[] stringArray = args = line.hasOption(CliFrontendParser.ARGS_OPTION.getOpt()) ? line.getOptionValues(CliFrontendParser.ARGS_OPTION.getOpt()) : line.getArgs();
            if (line.hasOption(CliFrontendParser.JAR_OPTION.getOpt())) {
                this.jarFilePath = line.getOptionValue(CliFrontendParser.JAR_OPTION.getOpt());
            } else if (args.length > 0) {
                this.jarFilePath = args[0];
                args = Arrays.copyOfRange(args, 1, args.length);
            } else {
                this.jarFilePath = null;
            }
            this.programArgs = args;
            ArrayList<URL> classpaths = new ArrayList<URL>();
            if (line.hasOption(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                for (String path : line.getOptionValues(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                    try {
                        classpaths.add(new URL(path));
                    }
                    catch (MalformedURLException e) {
                        throw new CliArgsException("Bad syntax for classpath: " + path);
                    }
                }
            }
            this.classpaths = classpaths;
            String string = this.entryPointClass = line.hasOption(CliFrontendParser.CLASS_OPTION.getOpt()) ? line.getOptionValue(CliFrontendParser.CLASS_OPTION.getOpt()) : null;
            if (line.hasOption(CliFrontendParser.PARALLELISM_OPTION.getOpt())) {
                String parString = line.getOptionValue(CliFrontendParser.PARALLELISM_OPTION.getOpt());
                try {
                    this.parallelism = Integer.parseInt(parString);
                    if (this.parallelism <= 0) {
                        throw new NumberFormatException();
                    }
                    break block12;
                }
                catch (NumberFormatException e) {
                    throw new CliArgsException("The parallelism must be a positive number: " + parString);
                }
            }
            this.parallelism = -1;
        }
        this.stdoutLogging = !line.hasOption(CliFrontendParser.LOGGING_OPTION.getOpt());
        this.detachedMode = line.hasOption(CliFrontendParser.DETACHED_OPTION.getOpt()) || line.hasOption(CliFrontendParser.YARN_DETACHED_OPTION.getOpt());
        this.savepointSettings = CliFrontendParser.createSavepointRestoreSettings(line);
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getEntryPointClassName() {
        return this.entryPointClass;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public String[] getProgramArgs() {
        return this.programArgs;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getStdoutLogging() {
        return this.stdoutLogging;
    }

    public boolean getDetachedMode() {
        return this.detachedMode;
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointSettings;
    }
}

