/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;
import org.assertj.core.api.Assertions;

public class AsyncSinkWriterTestUtils {
    public static <T extends Serializable> BufferedRequestState<T> getTestState(ElementConverter<String, T> elementConverter, Function<T, Integer> requestSizeExtractor) {
        return new BufferedRequestState(IntStream.range(0, 100).mapToObj(i -> String.format("value:%d", i)).map(element -> (Serializable)elementConverter.apply(element, null)).map(request -> new RequestEntryWrapper(request, (long)((Integer)requestSizeExtractor.apply(request)).intValue())).collect(Collectors.toList()));
    }

    public static <T extends Serializable> void assertThatBufferStatesAreEqual(BufferedRequestState<T> actual, BufferedRequestState<T> expected) {
        Assertions.assertThat((long)actual.getStateSize()).isEqualTo(expected.getStateSize());
        int actualLength = actual.getBufferedRequestEntries().size();
        Assertions.assertThat((int)actualLength).isEqualTo(expected.getBufferedRequestEntries().size());
        List actualRequests = actual.getBufferedRequestEntries();
        List expectedRequests = expected.getBufferedRequestEntries();
        for (int i = 0; i < actualLength; ++i) {
            Assertions.assertThat((Object)((RequestEntryWrapper)actualRequests.get(i)).getRequestEntry()).isEqualTo(((RequestEntryWrapper)expectedRequests.get(i)).getRequestEntry());
            Assertions.assertThat((long)((RequestEntryWrapper)actualRequests.get(i)).getSize()).isEqualTo(((RequestEntryWrapper)expectedRequests.get(i)).getSize());
        }
    }
}

