/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.connector.base.source.hybrid.HybridSource;
import org.apache.flink.connector.base.source.reader.mocks.MockBaseSource;
import org.apache.flink.connector.base.source.reader.mocks.MockSplitEnumerator;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class HybridSourceTest {
    @Test
    public void testBoundedness() {
        HybridSource source = HybridSource.builder((Source)new MockBaseSource(1, 1, Boundedness.BOUNDED)).addSource((Source)new MockBaseSource(1, 1, Boundedness.BOUNDED)).build();
        Assertions.assertThat((Comparable)source.getBoundedness()).isEqualTo((Object)Boundedness.BOUNDED);
        source = HybridSource.builder((Source)new MockBaseSource(1, 1, Boundedness.BOUNDED)).addSource((Source)new MockBaseSource(1, 1, Boundedness.CONTINUOUS_UNBOUNDED)).build();
        Assertions.assertThat((Comparable)source.getBoundedness()).isEqualTo((Object)Boundedness.CONTINUOUS_UNBOUNDED);
        Assertions.assertThatThrownBy(() -> HybridSource.builder((Source)new MockBaseSource(1, 1, Boundedness.CONTINUOUS_UNBOUNDED)).addSource((Source)new MockBaseSource(1, 1, Boundedness.CONTINUOUS_UNBOUNDED)).build()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testBuilderWithSourceFactory() {
        HybridSource.SourceFactory sourceFactory = new HybridSource.SourceFactory<Integer, Source<Integer, ?, ?>, MockSplitEnumerator>(){

            public Source<Integer, ?, ?> create(HybridSource.SourceSwitchContext<MockSplitEnumerator> context) {
                MockSplitEnumerator enumerator = (MockSplitEnumerator)context.getPreviousEnumerator();
                return new MockBaseSource(1, 1, Boundedness.BOUNDED);
            }
        };
        HybridSource source = new HybridSource.HybridSourceBuilder().addSource((Source)new MockBaseSource(1, 1, Boundedness.BOUNDED)).addSource(sourceFactory, Boundedness.BOUNDED).build();
        Assertions.assertThat((Object)source).isNotNull();
    }

    @Test
    public void testBuilderWithEnumeratorSuperclass() {
        HybridSource.SourceFactory & Serializable sourceFactory = (HybridSource.SourceFactory & Serializable)context -> {
            MockSplitEnumerator enumerator = (MockSplitEnumerator)context.getPreviousEnumerator();
            return new MockBaseSource(1, 1, Boundedness.BOUNDED);
        };
        HybridSource source = new HybridSource.HybridSourceBuilder().addSource((Source)new MockBaseSource(1, 1, Boundedness.BOUNDED)).addSource((HybridSource.SourceFactory)sourceFactory, Boundedness.BOUNDED).build();
        Assertions.assertThat((Object)source).isNotNull();
    }

    private static class ExtendedMockSplitEnumerator
    extends MockSplitEnumerator {
        public ExtendedMockSplitEnumerator(List<MockSourceSplit> splits, SplitEnumeratorContext<MockSourceSplit> context) {
            super(splits, context);
        }
    }
}

