/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.mocks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;

public class MockSplitEnumerator
implements SplitEnumerator<MockSourceSplit, List<MockSourceSplit>> {
    private final List<MockSourceSplit> splits;
    private final SplitEnumeratorContext<MockSourceSplit> context;

    public MockSplitEnumerator(List<MockSourceSplit> splits, SplitEnumeratorContext<MockSourceSplit> context) {
        this.splits = splits;
        this.context = context;
    }

    public void start() {
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
    }

    public void addSplitsBack(List<MockSourceSplit> splits, int subtaskId) {
        this.splits.addAll(splits);
    }

    public void addReader(int subtaskId) {
        if (this.context.registeredReaders().size() == this.context.currentParallelism()) {
            int i;
            int numReaders = this.context.registeredReaders().size();
            HashMap<Integer, List> assignment = new HashMap<Integer, List>();
            for (i = 0; i < this.splits.size(); ++i) {
                assignment.computeIfAbsent(i % numReaders, t -> new ArrayList()).add(this.splits.get(i));
            }
            this.context.assignSplits(new SplitsAssignment(assignment));
            this.splits.clear();
            for (i = 0; i < numReaders; ++i) {
                this.context.signalNoMoreSplits(i);
            }
        }
    }

    public List<MockSourceSplit> snapshotState(long checkpointId) {
        return this.splits;
    }

    public void close() throws IOException {
    }
}

