/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.connector.base.source.reader.mocks.TestingSourceSplit;
import org.apache.flink.connector.base.source.utils.SerdeUtils;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SerdeUtilsTest {
    private static final int READER0 = 0;
    private static final int READER1 = 1;

    @Test
    public void testSerdeSplitAssignments() throws IOException {
        HashMap splitAssignments = new HashMap();
        HashSet<TestingSourceSplit> splitsForReader0 = new HashSet<TestingSourceSplit>();
        splitsForReader0.add(new TestingSourceSplit("split-0"));
        splitsForReader0.add(new TestingSourceSplit("split-1"));
        splitsForReader0.add(new TestingSourceSplit("split-2"));
        HashSet<TestingSourceSplit> splitsForReader1 = new HashSet<TestingSourceSplit>();
        splitsForReader1.add(new TestingSourceSplit("split-3"));
        splitsForReader1.add(new TestingSourceSplit("split-4"));
        splitsForReader1.add(new TestingSourceSplit("split-5"));
        splitAssignments.put(0, splitsForReader0);
        splitAssignments.put(1, splitsForReader1);
        byte[] serializedSplitAssignments = SerdeUtils.serializeSplitAssignments(splitAssignments, (SimpleVersionedSerializer)new TestingSourceSplitSerializer());
        Map deseredSplitAssignments = SerdeUtils.deserializeSplitAssignments((byte[])serializedSplitAssignments, (SimpleVersionedSerializer)new TestingSourceSplitSerializer(), HashSet::new);
        Assertions.assertThat((Map)deseredSplitAssignments).isEqualTo(splitAssignments);
    }

    private static class TestingSourceSplitSerializer
    implements SimpleVersionedSerializer<TestingSourceSplit> {
        private TestingSourceSplitSerializer() {
        }

        public int getVersion() {
            return 0;
        }

        public byte[] serialize(TestingSourceSplit split) throws IOException {
            return split.splitId().getBytes(StandardCharsets.UTF_8);
        }

        public TestingSourceSplit deserialize(int version, byte[] serialized) throws IOException {
            return new TestingSourceSplit(new String(serialized, StandardCharsets.UTF_8));
        }
    }
}

