/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSinkCommittable
implements Serializable {
    @Nullable
    private final InProgressFileWriter.PendingFileRecoverable pendingFile;
    @Nullable
    private final InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup;

    public FileSinkCommittable(InProgressFileWriter.PendingFileRecoverable pendingFile) {
        this.pendingFile = (InProgressFileWriter.PendingFileRecoverable)Preconditions.checkNotNull((Object)pendingFile);
        this.inProgressFileToCleanup = null;
    }

    public FileSinkCommittable(InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup) {
        this.pendingFile = null;
        this.inProgressFileToCleanup = (InProgressFileWriter.InProgressFileRecoverable)Preconditions.checkNotNull((Object)inProgressFileToCleanup);
    }

    FileSinkCommittable(@Nullable InProgressFileWriter.PendingFileRecoverable pendingFile, @Nullable InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup) {
        this.pendingFile = pendingFile;
        this.inProgressFileToCleanup = inProgressFileToCleanup;
    }

    public boolean hasPendingFile() {
        return this.pendingFile != null;
    }

    @Nullable
    public InProgressFileWriter.PendingFileRecoverable getPendingFile() {
        return this.pendingFile;
    }

    public boolean hasInProgressFileToCleanup() {
        return this.inProgressFileToCleanup != null;
    }

    @Nullable
    public InProgressFileWriter.InProgressFileRecoverable getInProgressFileToCleanup() {
        return this.inProgressFileToCleanup;
    }
}

