/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.committer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class FileCommitter
implements Committer<FileSinkCommittable> {
    private final BucketWriter<?, ?> bucketWriter;

    public FileCommitter(BucketWriter<?, ?> bucketWriter) {
        this.bucketWriter = (BucketWriter)Preconditions.checkNotNull(bucketWriter);
    }

    public List<FileSinkCommittable> commit(List<FileSinkCommittable> committables) throws IOException {
        for (FileSinkCommittable committable : committables) {
            if (committable.hasPendingFile()) {
                this.bucketWriter.recoverPendingFile(committable.getPendingFile()).commitAfterRecovery();
            }
            if (!committable.hasInProgressFileToCleanup()) continue;
            this.bucketWriter.cleanupInProgressFileRecoverable(committable.getInProgressFileToCleanup());
        }
        return Collections.emptyList();
    }

    public void close() throws Exception {
    }
}

