/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

public enum TempMode {
    NONE(false, false),
    PIPELINE_BREAKER(false, true),
    CACHED(true, false),
    CACHING_PIPELINE_BREAKER(true, true);

    private final boolean cached;
    private final boolean breaksPipeline;

    private TempMode(boolean cached, boolean breaksPipeline) {
        this.cached = cached;
        this.breaksPipeline = breaksPipeline;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean breaksPipeline() {
        return this.breaksPipeline;
    }

    public TempMode makePipelineBreaker() {
        if (this == NONE) {
            return PIPELINE_BREAKER;
        }
        if (this == CACHED) {
            return CACHING_PIPELINE_BREAKER;
        }
        return this;
    }

    public TempMode makeCached() {
        if (this == NONE) {
            return CACHED;
        }
        if (this == PIPELINE_BREAKER) {
            return CACHING_PIPELINE_BREAKER;
        }
        return this;
    }

    public TempMode makeNonCached() {
        if (this == CACHED) {
            return NONE;
        }
        if (this == CACHING_PIPELINE_BREAKER) {
            return PIPELINE_BREAKER;
        }
        return this;
    }
}

