/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.flink.formats.parquet.vector.ParquetDecimalVector;
import org.apache.flink.formats.parquet.vector.ParquetSplitReaderUtil;
import org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.table.data.columnar.ColumnarRowData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetColumnarRowSplitReader
implements Closeable {
    private final boolean utcTimestamp;
    private final MessageType fileSchema;
    private final MessageType requestedSchema;
    private final long totalRowCount;
    private final WritableColumnVector[] writableVectors;
    private final VectorizedColumnBatch columnarBatch;
    private final ColumnarRowData row;
    private final LogicalType[] selectedTypes;
    private final int batchSize;
    private ParquetFileReader reader;
    private ColumnReader[] columnReaders;
    private long rowsReturned;
    private long totalCountLoadedSoFar;
    private int nextRow;
    private int rowsInBatch;

    public ParquetColumnarRowSplitReader(boolean utcTimestamp, boolean caseSensitive, Configuration conf, LogicalType[] selectedTypes, String[] selectedFieldNames, ColumnBatchGenerator generator, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        this.utcTimestamp = utcTimestamp;
        this.selectedTypes = selectedTypes;
        this.batchSize = batchSize;
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)path, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)splitStart, (long)(splitStart + splitLength)));
        MessageType fileSchema = footer.getFileMetaData().getSchema();
        FilterCompat.Filter filter = ParquetInputFormat.getFilter((Configuration)conf);
        List blocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter, (List)footer.getBlocks(), (MessageType)fileSchema);
        this.fileSchema = footer.getFileMetaData().getSchema();
        this.requestedSchema = ParquetColumnarRowSplitReader.clipParquetSchema((GroupType)fileSchema, selectedFieldNames, caseSensitive);
        this.reader = new ParquetFileReader(conf, footer.getFileMetaData(), path, blocks, this.requestedSchema.getColumns());
        long totalRowCount = 0L;
        for (BlockMetaData block : blocks) {
            totalRowCount += block.getRowCount();
        }
        this.totalRowCount = totalRowCount;
        this.nextRow = 0;
        this.rowsInBatch = 0;
        this.rowsReturned = 0L;
        this.checkSchema();
        this.writableVectors = this.createWritableVectors();
        this.columnarBatch = generator.generate(this.createReadableVectors());
        this.row = new ColumnarRowData(this.columnarBatch);
    }

    private static MessageType clipParquetSchema(GroupType parquetSchema, String[] fieldNames, boolean caseSensitive) {
        Type[] types = new Type[fieldNames.length];
        if (caseSensitive) {
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                if (parquetSchema.getFieldIndex(fieldName) < 0) {
                    throw new IllegalArgumentException(fieldName + " does not exist");
                }
                types[i] = parquetSchema.getType(fieldName);
            }
        } else {
            HashMap<String, Type> caseInsensitiveFieldMap = new HashMap<String, Type>();
            for (Type type : parquetSchema.getFields()) {
                caseInsensitiveFieldMap.compute(type.getName().toLowerCase(Locale.ROOT), (key, previousType) -> {
                    if (previousType != null) {
                        throw new FlinkRuntimeException("Parquet with case insensitive mode should have no duplicate key: " + key);
                    }
                    return type;
                });
            }
            for (int i = 0; i < fieldNames.length; ++i) {
                Type type;
                type = (Type)caseInsensitiveFieldMap.get(fieldNames[i].toLowerCase(Locale.ROOT));
                if (type == null) {
                    throw new IllegalArgumentException(fieldNames[i] + " does not exist");
                }
                types[i] = type;
            }
        }
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(types)).named("flink-parquet");
    }

    private WritableColumnVector[] createWritableVectors() {
        WritableColumnVector[] columns = new WritableColumnVector[this.selectedTypes.length];
        List types = this.requestedSchema.getFields();
        for (int i = 0; i < this.selectedTypes.length; ++i) {
            columns[i] = ParquetSplitReaderUtil.createWritableColumnVector(this.batchSize, this.selectedTypes[i], (Type)types.get(i), this.requestedSchema.getColumns(), 0);
        }
        return columns;
    }

    private ColumnVector[] createReadableVectors() {
        ColumnVector[] vectors = new ColumnVector[this.writableVectors.length];
        for (int i = 0; i < this.writableVectors.length; ++i) {
            vectors[i] = this.selectedTypes[i].getTypeRoot() == LogicalTypeRoot.DECIMAL ? new ParquetDecimalVector((ColumnVector)this.writableVectors[i]) : this.writableVectors[i];
        }
        return vectors;
    }

    private void checkSchema() throws IOException, UnsupportedOperationException {
        if (this.selectedTypes.length != this.requestedSchema.getFieldCount()) {
            throw new RuntimeException("The quality of field type is incompatible with the request schema!");
        }
        for (int i = 0; i < this.requestedSchema.getFieldCount(); ++i) {
            Object[] colPath = (String[])this.requestedSchema.getPaths().get(i);
            if (this.fileSchema.containsPath((String[])colPath)) {
                ColumnDescriptor fd = this.fileSchema.getColumnDescription((String[])colPath);
                if (fd.equals(this.requestedSchema.getColumns().get(i))) continue;
                throw new UnsupportedOperationException("Schema evolution not supported.");
            }
            if (((ColumnDescriptor)this.requestedSchema.getColumns().get(i)).getMaxDefinitionLevel() != 0) continue;
            throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(colPath));
        }
    }

    public boolean reachedEnd() throws IOException {
        return !this.ensureBatch();
    }

    public ColumnarRowData nextRecord() {
        this.row.setRowId(this.nextRow++);
        return this.row;
    }

    private boolean ensureBatch() throws IOException {
        if (this.nextRow >= this.rowsInBatch) {
            if (this.nextBatch()) {
                this.nextRow = 0;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean nextBatch() throws IOException {
        for (WritableColumnVector v : this.writableVectors) {
            v.reset();
        }
        this.columnarBatch.setNumRows(0);
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        if (this.rowsReturned == this.totalCountLoadedSoFar) {
            this.readNextRowGroup();
        }
        int num = (int)Math.min((long)this.batchSize, this.totalCountLoadedSoFar - this.rowsReturned);
        for (int i = 0; i < this.columnReaders.length; ++i) {
            this.columnReaders[i].readToVector(num, this.writableVectors[i]);
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        this.rowsInBatch = num;
        return true;
    }

    private void readNextRowGroup() throws IOException {
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List types = this.requestedSchema.getFields();
        this.columnReaders = new ColumnReader[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            this.columnReaders[i] = ParquetSplitReaderUtil.createColumnReader(this.utcTimestamp, this.selectedTypes[i], (Type)types.get(i), this.requestedSchema.getColumns(), pages, 0);
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    public void seekToRow(long rowCount) throws IOException {
        BlockMetaData metaData;
        if (this.totalCountLoadedSoFar != 0L) {
            throw new UnsupportedOperationException("Only support seek at first.");
        }
        List blockMetaData = this.reader.getRowGroups();
        Iterator iterator = blockMetaData.iterator();
        while (iterator.hasNext() && (metaData = (BlockMetaData)iterator.next()).getRowCount() <= rowCount) {
            this.reader.skipNextRowGroup();
            this.rowsReturned += metaData.getRowCount();
            this.totalCountLoadedSoFar += metaData.getRowCount();
            this.rowsInBatch = (int)metaData.getRowCount();
            this.nextRow = (int)metaData.getRowCount();
            rowCount -= metaData.getRowCount();
        }
        int i = 0;
        while ((long)i < rowCount) {
            boolean end = this.reachedEnd();
            if (end) {
                throw new RuntimeException("Seek to many rows.");
            }
            this.nextRecord();
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public static interface ColumnBatchGenerator {
        public VectorizedColumnBatch generate(ColumnVector[] var1);
    }
}

