/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.vector;

import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.columnar.vector.BytesColumnVector;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.DecimalColumnVector;
import org.apache.flink.table.data.columnar.vector.IntColumnVector;
import org.apache.flink.table.data.columnar.vector.LongColumnVector;
import org.apache.parquet.Preconditions;

@Internal
public class ParquetDecimalVector
implements DecimalColumnVector {
    private final ColumnVector vector;

    public ParquetDecimalVector(ColumnVector vector) {
        this.vector = vector;
    }

    public DecimalData getDecimal(int i, int precision, int scale) {
        if (ParquetSchemaConverter.is32BitDecimal(precision) && this.vector instanceof IntColumnVector) {
            return DecimalData.fromUnscaledLong((long)((IntColumnVector)this.vector).getInt(i), (int)precision, (int)scale);
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision) && this.vector instanceof LongColumnVector) {
            return DecimalData.fromUnscaledLong((long)((LongColumnVector)this.vector).getLong(i), (int)precision, (int)scale);
        }
        Preconditions.checkArgument((boolean)(this.vector instanceof BytesColumnVector), (String)"Reading decimal type occur unsupported vector type: %s", (Object[])new Object[]{this.vector.getClass()});
        return DecimalData.fromUnscaledBytes((byte[])((BytesColumnVector)this.vector).getBytes(i).getBytes(), (int)precision, (int)scale);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }
}

