/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.topology.Result;
import org.apache.flink.runtime.topology.Vertex;

public final class PipelinedRegionComputeUtil {
    static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> Map<V, Set<V>> buildRawRegions(Iterable<? extends V> topologicallySortedVertices, Function<V, Iterable<R>> getNonReconnectableConsumedResults) {
        IdentityHashMap vertexToRegion = new IdentityHashMap();
        for (Vertex vertex : topologicallySortedVertices) {
            Set currentRegion = new HashSet<Vertex>();
            currentRegion.add(vertex);
            vertexToRegion.put(vertex, currentRegion);
            for (Result consumedResult : getNonReconnectableConsumedResults.apply(vertex)) {
                Object producerVertex = consumedResult.getProducer();
                Set producerRegion = (Set)vertexToRegion.get(producerVertex);
                if (producerRegion == null) {
                    throw new IllegalStateException("Producer task " + producerVertex.getId() + " failover region is null while calculating failover region for the consumer task " + vertex.getId() + ". This should be a failover region building bug.");
                }
                if (currentRegion == producerRegion) continue;
                currentRegion = PipelinedRegionComputeUtil.mergeRegions(currentRegion, producerRegion, vertexToRegion);
            }
        }
        return vertexToRegion;
    }

    static <V extends Vertex<?, ?, V, ?>> Set<V> mergeRegions(Set<V> region1, Set<V> region2, Map<V, Set<V>> vertexToRegion) {
        Set<V> largerSet;
        Set<V> smallerSet;
        if (region1.size() < region2.size()) {
            smallerSet = region1;
            largerSet = region2;
        } else {
            smallerSet = region2;
            largerSet = region1;
        }
        for (Vertex v : smallerSet) {
            vertexToRegion.put((Set<V>)((Object)v), (Set<Set<V>>)largerSet);
        }
        largerSet.addAll(smallerSet);
        return largerSet;
    }

    static <V extends Vertex<?, ?, V, ?>> Set<Set<V>> uniqueRegions(Map<V, Set<V>> vertexToRegion) {
        Set<Set<V>> distinctRegions = Collections.newSetFromMap(new IdentityHashMap());
        distinctRegions.addAll(vertexToRegion.values());
        return distinctRegions;
    }

    private PipelinedRegionComputeUtil() {
    }
}

