/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.logger;

import java.io.Closeable;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.consumer.ChannelStatePersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkActionsLogger {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkActionsLogger.class);
    private static final boolean INCLUDE_HASH = true;
    private static final long MAX_EXPECTED_IO_TIME_IN_MS = 100L;
    private static final Closeable NO_MEASURE = () -> {};

    public static void traceInput(String action, Buffer buffer, String taskName, InputChannelInfo channelInfo, ChannelStatePersister channelStatePersister, int sequenceNumber) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] {} {}, seq {}, {} @ {}", new Object[]{taskName, action, buffer.toDebugString(true), sequenceNumber, channelStatePersister, channelInfo});
        }
    }

    public static void traceOutput(String action, Buffer buffer, String taskName, ResultSubpartitionInfo channelInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] {} {} @ {}", new Object[]{taskName, action, buffer.toDebugString(true), channelInfo});
        }
    }

    public static void traceRecover(String action, Buffer buffer, String taskName, InputChannelInfo channelInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] {} {} @ {}", new Object[]{taskName, action, buffer.toDebugString(true), channelInfo});
        }
    }

    public static void traceRecover(String action, BufferConsumer bufferConsumer, String taskName, ResultSubpartitionInfo channelInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] {} {} @ {}", new Object[]{taskName, action, bufferConsumer.toDebugString(true), channelInfo});
        }
    }

    public static void tracePersist(String action, Buffer buffer, String taskName, Object channelInfo, long checkpointId) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("[{}] {} {}, checkpoint {} @ {}", new Object[]{taskName, action, buffer.toDebugString(true), checkpointId, channelInfo});
        }
    }

    public static Closeable measureIO(String action, Object entity) {
        if (!LOG.isDebugEnabled()) {
            return NO_MEASURE;
        }
        long startTime = System.currentTimeMillis();
        return () -> {
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (elapsedTime > 100L) {
                LOG.debug("{} {} took unexpected long ({} ms) indicating that the checkpoint storage is overloaded.", new Object[]{action, entity, elapsedTime});
            }
        };
    }
}

