/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.NetworkClientHandler;
import org.apache.flink.runtime.io.network.netty.BufferResponseDecoder;
import org.apache.flink.runtime.io.network.netty.ByteBufUtils;
import org.apache.flink.runtime.io.network.netty.NettyMessageDecoder;
import org.apache.flink.runtime.io.network.netty.NetworkBufferAllocator;
import org.apache.flink.runtime.io.network.netty.NonBufferResponseDecoder;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyMessageClientDecoderDelegate
extends ChannelInboundHandlerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(NettyMessageClientDecoderDelegate.class);
    private final NettyMessageDecoder bufferResponseDecoder;
    private final NettyMessageDecoder nonBufferResponseDecoder;
    private ByteBuf frameHeaderBuffer;
    private NettyMessageDecoder currentDecoder;

    NettyMessageClientDecoderDelegate(NetworkClientHandler networkClientHandler) {
        this.bufferResponseDecoder = new BufferResponseDecoder(new NetworkBufferAllocator((NetworkClientHandler)Preconditions.checkNotNull((Object)networkClientHandler)));
        this.nonBufferResponseDecoder = new NonBufferResponseDecoder();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.bufferResponseDecoder.onChannelActive(ctx);
        this.nonBufferResponseDecoder.onChannelActive(ctx);
        this.frameHeaderBuffer = ctx.alloc().directBuffer(9);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        IOUtils.cleanup((Logger)this.LOG, (AutoCloseable[])new AutoCloseable[]{this.bufferResponseDecoder, this.nonBufferResponseDecoder});
        this.frameHeaderBuffer.release();
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf data = (ByteBuf)msg;
        try {
            while (data.isReadable()) {
                if (this.currentDecoder != null) {
                    NettyMessageDecoder.DecodingResult result = this.currentDecoder.onChannelRead(data);
                    if (!result.isFinished()) break;
                    ctx.fireChannelRead((Object)result.getMessage());
                    this.currentDecoder = null;
                    this.frameHeaderBuffer.clear();
                }
                this.decodeFrameHeader(data);
            }
            Preconditions.checkState((!data.isReadable() ? 1 : 0) != 0, (Object)"Not all data of the received buffer consumed.");
        }
        finally {
            data.release();
        }
    }

    private void decodeFrameHeader(ByteBuf data) {
        ByteBuf fullFrameHeaderBuf = ByteBufUtils.accumulate(this.frameHeaderBuffer, data, 9, this.frameHeaderBuffer.readableBytes());
        if (fullFrameHeaderBuf != null) {
            int messageAndFrameLength = fullFrameHeaderBuf.readInt();
            Preconditions.checkState((messageAndFrameLength >= 0 ? 1 : 0) != 0, (Object)"The length field of current message must be non-negative");
            int magicNumber = fullFrameHeaderBuf.readInt();
            Preconditions.checkState((magicNumber == -1159983106 ? 1 : 0) != 0, (Object)"Network stream corrupted: received incorrect magic number.");
            byte msgId = fullFrameHeaderBuf.readByte();
            this.currentDecoder = msgId == 0 ? this.bufferResponseDecoder : this.nonBufferResponseDecoder;
            this.currentDecoder.onNewMessageReceived(msgId, messageAndFrameLength - 9);
        }
    }
}

