/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.CircularQueues;
import org.apache.flink.runtime.operators.sort.ExternalSorterBuilder;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.sort.Sorter;
import org.apache.flink.runtime.operators.sort.SpillChannelManager;
import org.apache.flink.runtime.operators.sort.StageRunner;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSorter<E>
implements Sorter<E> {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalSorter.class);
    private final StageRunner readThread;
    private final StageRunner sortThread;
    private final StageRunner spillThread;
    private final List<MemorySegment> sortReadMemory;
    private final List<MemorySegment> writeMemory;
    private final MemoryManager memoryManager;
    private final LargeRecordHandler<E> largeRecordHandler;
    private final SpillChannelManager spillChannelManager;
    private final CircularQueues<E> queues;
    private volatile boolean closed;
    private final Collection<InMemorySorter<E>> inMemorySorters;

    ExternalSorter(@Nullable StageRunner readThread, StageRunner sortThread, StageRunner spillThread, List<MemorySegment> sortReadMemory, List<MemorySegment> writeMemory, MemoryManager memoryManager, @Nullable LargeRecordHandler<E> largeRecordHandler, SpillChannelManager spillChannelManager, Collection<InMemorySorter<E>> inMemorySorters, CircularQueues<E> queues) {
        this.readThread = readThread;
        this.sortThread = (StageRunner)Preconditions.checkNotNull((Object)sortThread);
        this.spillThread = (StageRunner)Preconditions.checkNotNull((Object)spillThread);
        this.sortReadMemory = (List)Preconditions.checkNotNull(sortReadMemory);
        this.writeMemory = (List)Preconditions.checkNotNull(writeMemory);
        this.memoryManager = (MemoryManager)Preconditions.checkNotNull((Object)memoryManager);
        this.largeRecordHandler = largeRecordHandler;
        this.spillChannelManager = (SpillChannelManager)Preconditions.checkNotNull((Object)spillChannelManager);
        this.inMemorySorters = (Collection)Preconditions.checkNotNull(inMemorySorters);
        this.queues = (CircularQueues)Preconditions.checkNotNull(queues);
        this.queues.getIteratorFuture().whenComplete((iterator, throwable) -> {
            if (throwable != null) {
                this.close();
            }
        });
        this.startThreads();
    }

    private void startThreads() {
        if (this.readThread != null) {
            this.readThread.start();
        }
        this.sortThread.start();
        this.spillThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object externalSorter = this;
        synchronized (externalSorter) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            if (this.readThread != null) {
                this.closeThread(this.readThread, "reader");
            }
            this.closeThread(this.sortThread, "sorter");
            this.closeThread(this.spillThread, "spilling");
            this.queues.close();
            externalSorter = this.inMemorySorters.iterator();
        }
        catch (Throwable throwable) {
            this.queues.close();
            for (InMemorySorter<E> inMemorySorter : this.inMemorySorters) {
                inMemorySorter.dispose();
            }
            try {
                if (!this.writeMemory.isEmpty()) {
                    this.memoryManager.release(this.writeMemory);
                }
                this.writeMemory.clear();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            try {
                if (!this.sortReadMemory.isEmpty()) {
                    this.memoryManager.release(this.sortReadMemory);
                }
                this.sortReadMemory.clear();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            this.spillChannelManager.close();
            try {
                if (this.largeRecordHandler == null) throw throwable;
                this.largeRecordHandler.close();
                throw throwable;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw throwable;
        }
        while (externalSorter.hasNext()) {
            InMemorySorter inMemorySorter = (InMemorySorter)externalSorter.next();
            inMemorySorter.dispose();
        }
        try {
            if (!this.writeMemory.isEmpty()) {
                this.memoryManager.release(this.writeMemory);
            }
            this.writeMemory.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!this.sortReadMemory.isEmpty()) {
                this.memoryManager.release(this.sortReadMemory);
            }
            this.sortReadMemory.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.spillChannelManager.close();
        try {
            if (this.largeRecordHandler == null) return;
            this.largeRecordHandler.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void closeThread(StageRunner thread, String threadName) {
        try {
            thread.close();
        }
        catch (InterruptedException ie) {
            LOG.debug(String.format("Closing of %s was interrupted. The %s thread may still be working.", threadName, threadName), (Throwable)ie);
        }
        catch (Throwable t) {
            LOG.error(String.format("Error shutting down %s thread: %s", threadName, t.getMessage()), t);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MutableObjectIterator<E> getIterator() throws InterruptedException {
        try {
            return (MutableObjectIterator)((CompletableFuture)this.queues.getIteratorFuture().exceptionally(exception -> {
                throw new RuntimeException("Error obtaining the sorted input: " + exception.getMessage(), (Throwable)exception);
            })).get();
        }
        catch (ExecutionException e) {
            this.close();
            throw new WrappingRuntimeException((Throwable)e);
        }
    }

    public static <E> ExternalSorterBuilder<E> newBuilder(MemoryManager memoryManager, TaskInvokable parentTask, TypeSerializer<E> serializer, TypeComparator<E> comparator, ExecutionConfig executionConfig) {
        return new ExternalSorterBuilder((MemoryManager)Preconditions.checkNotNull((Object)memoryManager), (TaskInvokable)Preconditions.checkNotNull((Object)parentTask), (TypeSerializer)Preconditions.checkNotNull(serializer), (TypeComparator)Preconditions.checkNotNull(comparator), (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig));
    }

    public static <E> ExternalSorterBuilder<E> newBuilder(MemoryManager memoryManager, AbstractInvokable parentTask, TypeSerializer<E> serializer, TypeComparator<E> comparator) {
        return ExternalSorter.newBuilder((MemoryManager)Preconditions.checkNotNull((Object)memoryManager), (TaskInvokable)Preconditions.checkNotNull((Object)parentTask), (TypeSerializer)Preconditions.checkNotNull(serializer), (TypeComparator)Preconditions.checkNotNull(comparator), parentTask.getExecutionConfig());
    }
}

