/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.AbstractStateTableSnapshot;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.heap.NestedStateMap;
import org.apache.flink.runtime.state.heap.StateMap;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;
import org.apache.flink.runtime.state.heap.StateTable;

@Internal
public class NestedMapsStateTable<K, N, S>
extends StateTable<K, N, S> {
    public NestedMapsStateTable(InternalKeyContext<K> keyContext, RegisteredKeyValueStateBackendMetaInfo<N, S> metaInfo, TypeSerializer<K> keySerializer) {
        super(keyContext, metaInfo, keySerializer);
    }

    @Override
    protected NestedStateMap<K, N, S> createStateMap() {
        return new NestedStateMap();
    }

    @Override
    @Nonnull
    public NestedMapsStateTableSnapshot<K, N, S> stateSnapshot() {
        return new NestedMapsStateTableSnapshot(this, this.getKeySerializer(), this.getNamespaceSerializer(), this.getStateSerializer(), (StateSnapshotTransformer)this.getMetaInfo().getStateSnapshotTransformFactory().createForDeserializedState().orElse(null));
    }

    static class NestedMapsStateTableSnapshot<K, N, S>
    extends AbstractStateTableSnapshot<K, N, S> {
        NestedMapsStateTableSnapshot(NestedMapsStateTable<K, N, S> owningTable, TypeSerializer<K> localKeySerializer, TypeSerializer<N> localNamespaceSerializer, TypeSerializer<S> localStateSerializer, StateSnapshotTransformer<S> stateSnapshotTransformer) {
            super(owningTable, localKeySerializer, localNamespaceSerializer, localStateSerializer, stateSnapshotTransformer);
        }

        @Override
        protected StateMapSnapshot<K, N, S, ? extends StateMap<K, N, S>> getStateMapSnapshotForKeyGroup(int keyGroup) {
            return this.owningStateTable.getMapForKeyGroup(keyGroup).stateSnapshot();
        }

        @Override
        public void release() {
        }
    }
}

