/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.CheckpointedResultPartition;
import org.apache.flink.runtime.io.network.partition.CheckpointedResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;

public class ConsumableNotifyingResultPartitionWriterDecorator {
    public static ResultPartitionWriter[] decorate(Collection<ResultPartitionDeploymentDescriptor> descs, ResultPartitionWriter[] partitionWriters, TaskActions taskActions, JobID jobId, ResultPartitionConsumableNotifier notifier) {
        ResultPartitionWriter[] consumableNotifyingPartitionWriters = new ResultPartitionWriter[partitionWriters.length];
        int counter = 0;
        for (ResultPartitionDeploymentDescriptor desc : descs) {
            consumableNotifyingPartitionWriters[counter] = desc.notifyPartitionDataAvailable() && desc.getPartitionType().isPipelined() ? new ConsumableNotifyingResultPartitionWriter(taskActions, jobId, partitionWriters[counter], notifier) : partitionWriters[counter];
            ++counter;
        }
        return consumableNotifyingPartitionWriters;
    }

    private ConsumableNotifyingResultPartitionWriterDecorator() {
    }

    private static final class ConsumableNotifyingResultPartitionWriter
    implements ResultPartitionWriter,
    CheckpointedResultPartition {
        private final TaskActions taskActions;
        private final JobID jobId;
        private final ResultPartitionWriter partitionWriter;
        private final ResultPartitionConsumableNotifier partitionConsumableNotifier;
        private boolean hasNotifiedPipelinedConsumers;

        public ConsumableNotifyingResultPartitionWriter(TaskActions taskActions, JobID jobId, ResultPartitionWriter partitionWriter, ResultPartitionConsumableNotifier partitionConsumableNotifier) {
            this.taskActions = (TaskActions)Preconditions.checkNotNull((Object)taskActions);
            this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
            this.partitionWriter = (ResultPartitionWriter)Preconditions.checkNotNull((Object)partitionWriter);
            this.partitionConsumableNotifier = (ResultPartitionConsumableNotifier)Preconditions.checkNotNull((Object)partitionConsumableNotifier);
        }

        @Override
        public ResultPartitionID getPartitionId() {
            return this.partitionWriter.getPartitionId();
        }

        @Override
        public int getNumberOfSubpartitions() {
            return this.partitionWriter.getNumberOfSubpartitions();
        }

        @Override
        public int getNumTargetKeyGroups() {
            return this.partitionWriter.getNumTargetKeyGroups();
        }

        @Override
        public void setup() throws IOException {
            this.partitionWriter.setup();
        }

        @Override
        public void emitRecord(ByteBuffer record, int targetSubpartition) throws IOException {
            this.partitionWriter.emitRecord(record, targetSubpartition);
            this.notifyPipelinedConsumers();
        }

        @Override
        public void broadcastRecord(ByteBuffer record) throws IOException {
            this.partitionWriter.broadcastRecord(record);
            this.notifyPipelinedConsumers();
        }

        @Override
        public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) throws IOException {
            this.partitionWriter.broadcastEvent(event, isPriorityEvent);
            this.notifyPipelinedConsumers();
        }

        @Override
        public void notifyEndOfData() throws IOException {
            this.partitionWriter.notifyEndOfData();
        }

        @Override
        public CompletableFuture<Void> getAllDataProcessedFuture() {
            return this.partitionWriter.getAllDataProcessedFuture();
        }

        @Override
        public void setMetricGroup(TaskIOMetricGroup metrics) {
            this.partitionWriter.setMetricGroup(metrics);
        }

        @Override
        public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) throws IOException {
            return this.partitionWriter.createSubpartitionView(index, availabilityListener);
        }

        @Override
        public void flushAll() {
            this.partitionWriter.flushAll();
        }

        @Override
        public void flush(int subpartitionIndex) {
            this.partitionWriter.flush(subpartitionIndex);
        }

        @Override
        public void finish() throws IOException {
            this.partitionWriter.finish();
            this.notifyPipelinedConsumers();
        }

        @Override
        public boolean isFinished() {
            return this.partitionWriter.isFinished();
        }

        @Override
        public void release(Throwable cause) {
            this.partitionWriter.release(cause);
        }

        @Override
        public boolean isReleased() {
            return this.partitionWriter.isReleased();
        }

        @Override
        public void fail(Throwable throwable) {
            this.partitionWriter.fail(throwable);
        }

        @Override
        public CompletableFuture<?> getAvailableFuture() {
            return this.partitionWriter.getAvailableFuture();
        }

        @Override
        public void close() throws Exception {
            this.partitionWriter.close();
        }

        @Override
        public void finishReadRecoveredState(boolean notifyAndBlockOnCompletion) throws IOException {
            this.getCheckpointablePartition().finishReadRecoveredState(notifyAndBlockOnCompletion);
        }

        private void notifyPipelinedConsumers() {
            if (!this.hasNotifiedPipelinedConsumers && !this.partitionWriter.isReleased()) {
                this.partitionConsumableNotifier.notifyPartitionConsumable(this.jobId, this.partitionWriter.getPartitionId(), this.taskActions);
                this.hasNotifiedPipelinedConsumers = true;
            }
        }

        @Override
        public CheckpointedResultSubpartition getCheckpointedSubpartition(int subpartitionIndex) {
            return this.getCheckpointablePartition().getCheckpointedSubpartition(subpartitionIndex);
        }

        private CheckpointedResultPartition getCheckpointablePartition() {
            if (this.partitionWriter instanceof CheckpointedResultPartition) {
                return (CheckpointedResultPartition)((Object)this.partitionWriter);
            }
            throw new IllegalStateException("This partition is not checkpointable: " + this.partitionWriter);
        }
    }
}

