/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndex;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexCache;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexSpilledRegionManagerImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileRegionWriteReadUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

@ThreadSafe
public class HsFileDataIndexImpl
implements HsFileDataIndex {
    @GuardedBy(value="lock")
    private final FileDataIndexCache<InternalRegion> indexCache;
    private final Object lock = new Object();

    public HsFileDataIndexImpl(int numSubpartitions, Path indexFilePath, int regionGroupSizeInBytes, long numRetainedInMemoryRegionsMax) {
        this.indexCache = new FileDataIndexCache<InternalRegion>(numSubpartitions, indexFilePath, numRetainedInMemoryRegionsMax, new FileDataIndexSpilledRegionManagerImpl.Factory<InternalRegion>(regionGroupSizeInBytes, numRetainedInMemoryRegionsMax, 16, HsFileDataIndexRegionHelper.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.indexCache.close();
            }
            catch (IOException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<HsFileDataIndex.ReadableRegion> getReadableRegion(int subpartitionId, int bufferIndex, int consumingOffset) {
        Object object = this.lock;
        synchronized (object) {
            return this.getInternalRegion(subpartitionId, bufferIndex).map(internalRegion -> ((InternalRegion)internalRegion).toReadableRegion(bufferIndex, consumingOffset)).filter(internalRegion -> internalRegion.numReadable > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBuffers(List<HsFileDataIndex.SpilledBuffer> spilledBuffers) {
        Map<Integer, List<InternalRegion>> subpartitionInternalRegions = HsFileDataIndexImpl.convertToInternalRegions(spilledBuffers);
        Object object = this.lock;
        synchronized (object) {
            subpartitionInternalRegions.forEach(this.indexCache::put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markBufferReleased(int subpartitionId, int bufferIndex) {
        Object object = this.lock;
        synchronized (object) {
            this.getInternalRegion(subpartitionId, bufferIndex).ifPresent(internalRegion -> ((InternalRegion)internalRegion).markBufferReleased(bufferIndex));
        }
    }

    @GuardedBy(value="lock")
    private Optional<InternalRegion> getInternalRegion(int subpartitionId, int bufferIndex) {
        return this.indexCache.get(subpartitionId, bufferIndex);
    }

    private static Map<Integer, List<InternalRegion>> convertToInternalRegions(List<HsFileDataIndex.SpilledBuffer> spilledBuffers) {
        HsFileDataIndex.SpilledBuffer firstBufferOfCurrentRegion;
        if (spilledBuffers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<InternalRegion>> internalRegionsBySubpartition = new HashMap<Integer, List<InternalRegion>>();
        Iterator<HsFileDataIndex.SpilledBuffer> iterator = spilledBuffers.iterator();
        HsFileDataIndex.SpilledBuffer lastBufferOfCurrentRegion = firstBufferOfCurrentRegion = iterator.next();
        while (iterator.hasNext()) {
            HsFileDataIndex.SpilledBuffer currentBuffer = iterator.next();
            if (currentBuffer.subpartitionId != firstBufferOfCurrentRegion.subpartitionId || currentBuffer.bufferIndex != lastBufferOfCurrentRegion.bufferIndex + 1) {
                HsFileDataIndexImpl.addInternalRegionToMap(firstBufferOfCurrentRegion, lastBufferOfCurrentRegion, internalRegionsBySubpartition);
                firstBufferOfCurrentRegion = currentBuffer;
            }
            lastBufferOfCurrentRegion = currentBuffer;
        }
        HsFileDataIndexImpl.addInternalRegionToMap(firstBufferOfCurrentRegion, lastBufferOfCurrentRegion, internalRegionsBySubpartition);
        return internalRegionsBySubpartition;
    }

    private static void addInternalRegionToMap(HsFileDataIndex.SpilledBuffer firstBufferInRegion, HsFileDataIndex.SpilledBuffer lastBufferInRegion, Map<Integer, List<InternalRegion>> internalRegionsBySubpartition) {
        Preconditions.checkArgument((firstBufferInRegion.subpartitionId == lastBufferInRegion.subpartitionId ? 1 : 0) != 0);
        Preconditions.checkArgument((firstBufferInRegion.bufferIndex <= lastBufferInRegion.bufferIndex ? 1 : 0) != 0);
        internalRegionsBySubpartition.computeIfAbsent(firstBufferInRegion.subpartitionId, ArrayList::new).add(new InternalRegion(firstBufferInRegion.bufferIndex, firstBufferInRegion.fileOffset, lastBufferInRegion.bufferIndex - firstBufferInRegion.bufferIndex + 1));
    }

    public static class HsFileDataIndexRegionHelper
    implements FileDataIndexRegionHelper<InternalRegion> {
        private final ByteBuffer regionHeaderBuffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer(16);
        public static final HsFileDataIndexRegionHelper INSTANCE = new HsFileDataIndexRegionHelper();

        private HsFileDataIndexRegionHelper() {
        }

        @Override
        public void writeRegionToFile(FileChannel channel, InternalRegion region) throws IOException {
            FileRegionWriteReadUtils.writeHsInternalRegionToFile(channel, this.regionHeaderBuffer, region);
        }

        @Override
        public InternalRegion readRegionFromFile(FileChannel channel, long fileOffset) throws IOException {
            return FileRegionWriteReadUtils.readHsInternalRegionFromFile(channel, this.regionHeaderBuffer, fileOffset);
        }
    }

    public static class InternalRegion
    implements FileDataIndexRegionHelper.Region {
        public static final int HEADER_SIZE = 16;
        private final int firstBufferIndex;
        private final long regionFileOffset;
        private final int numBuffers;
        private final boolean[] released;

        private InternalRegion(int firstBufferIndex, long regionFileOffset, int numBuffers) {
            this.firstBufferIndex = firstBufferIndex;
            this.regionFileOffset = regionFileOffset;
            this.numBuffers = numBuffers;
            this.released = new boolean[numBuffers];
            Arrays.fill(this.released, false);
        }

        public InternalRegion(int firstBufferIndex, long regionFileOffset, int numBuffers, boolean[] released) {
            this.firstBufferIndex = firstBufferIndex;
            this.regionFileOffset = regionFileOffset;
            this.numBuffers = numBuffers;
            this.released = released;
        }

        @Override
        public boolean containBuffer(int bufferIndex) {
            return bufferIndex >= this.firstBufferIndex && bufferIndex < this.firstBufferIndex + this.numBuffers;
        }

        @Override
        public int getSize() {
            return 16 + this.numBuffers;
        }

        @Override
        public int getFirstBufferIndex() {
            return this.firstBufferIndex;
        }

        @Override
        public long getRegionStartOffset() {
            return this.regionFileOffset;
        }

        @Override
        public long getRegionEndOffset() {
            throw new UnsupportedOperationException("This method is not supported.");
        }

        @Override
        public int getNumBuffers() {
            return this.numBuffers;
        }

        private HsFileDataIndex.ReadableRegion toReadableRegion(int bufferIndex, int consumingOffset) {
            int nSkip = bufferIndex - this.firstBufferIndex;
            int nReadable = 0;
            while (nSkip + nReadable < this.numBuffers && this.released[nSkip + nReadable] && bufferIndex + nReadable > consumingOffset) {
                ++nReadable;
            }
            return new HsFileDataIndex.ReadableRegion(nSkip, nReadable, this.regionFileOffset);
        }

        private void markBufferReleased(int bufferIndex) {
            this.released[bufferIndex - this.firstBufferIndex] = true;
        }

        public boolean[] getReleased() {
            return this.released;
        }
    }
}

