/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;

public class ThroughputCalculator {
    private static final long NOT_TRACKED = -1L;
    private final Clock clock;
    private static final long MILLIS_IN_SECOND = 1000L;
    private long currentThroughput;
    private long currentAccumulatedDataSize;
    private long currentMeasurementTime;
    private long measurementStartTime = -1L;

    public ThroughputCalculator(Clock clock) {
        this.clock = clock;
    }

    public void incomingDataSize(long receivedDataSize) {
        if (this.measurementStartTime == -1L) {
            this.measurementStartTime = this.clock.absoluteTimeMillis();
        }
        this.currentAccumulatedDataSize += receivedDataSize;
    }

    public void pauseMeasurement() {
        if (this.measurementStartTime != -1L) {
            this.currentMeasurementTime += this.clock.absoluteTimeMillis() - this.measurementStartTime;
        }
        this.measurementStartTime = -1L;
    }

    public void resumeMeasurement() {
        if (this.measurementStartTime == -1L) {
            this.measurementStartTime = this.clock.absoluteTimeMillis();
        }
    }

    public long calculateThroughput() {
        if (this.measurementStartTime != -1L) {
            long absoluteTimeMillis = this.clock.absoluteTimeMillis();
            this.currentMeasurementTime += absoluteTimeMillis - this.measurementStartTime;
            this.measurementStartTime = absoluteTimeMillis;
        }
        long throughput = this.calculateThroughput(this.currentAccumulatedDataSize, this.currentMeasurementTime);
        this.currentMeasurementTime = 0L;
        this.currentAccumulatedDataSize = 0L;
        return throughput;
    }

    public long calculateThroughput(long dataSize, long time) {
        Preconditions.checkArgument((dataSize >= 0L ? 1 : 0) != 0, (Object)"Size of data should be non negative");
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"Time should be non negative");
        if (time == 0L) {
            return this.currentThroughput;
        }
        this.currentThroughput = ThroughputCalculator.instantThroughput(dataSize, time);
        return this.currentThroughput;
    }

    static long instantThroughput(long dataSize, long time) {
        return (long)((double)dataSize / (double)time * 1000.0);
    }
}

