/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.Patterns;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class StandaloneMiniCluster {
    private static final String LOCAL_HOSTNAME = "localhost";
    private final Configuration configuration;
    private final ActorSystem actorSystem;
    private final ScheduledExecutorService scheduledExecutorService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final FiniteDuration timeout;
    private final int port;

    public StandaloneMiniCluster(Configuration configuration) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.timeout = AkkaUtils.getTimeout(configuration);
        this.actorSystem = JobManager.startActorSystem(configuration, LOCAL_HOSTNAME, 0);
        this.port = configuration.getInteger(JobManagerOptions.PORT);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
        this.highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, Executors.directExecutor(), HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        JobManager.startJobManagerActors(configuration, this.actorSystem, this.scheduledExecutorService, this.scheduledExecutorService, this.highAvailabilityServices, JobManager.class, MemoryArchivist.class);
        ActorRef taskManager = TaskManager.startTaskManagerComponentsAndActor(configuration, ResourceID.generate(), this.actorSystem, this.highAvailabilityServices, LOCAL_HOSTNAME, (Option<String>)Option.empty(), true, TaskManager.class);
        Future registrationFuture = Patterns.ask((ActorRef)taskManager, (Object)TaskManagerMessages.getNotifyWhenRegisteredAtJobManagerMessage(), (long)this.timeout.toMillis());
        Await.ready((Awaitable)registrationFuture, (Duration)this.timeout);
    }

    public String getHostname() {
        return LOCAL_HOSTNAME;
    }

    public int getPort() {
        return this.port;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void close() throws Exception {
        Exception exception = null;
        this.actorSystem.shutdown();
        this.actorSystem.awaitTermination();
        try {
            this.highAvailabilityServices.closeAndCleanupAllData();
        }
        catch (Exception e) {
            exception = e;
        }
        this.scheduledExecutorService.shutdownNow();
        try {
            this.scheduledExecutorService.awaitTermination(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

