/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateID;
import org.apache.flink.runtime.query.KvStateServerAddress;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.util.Preconditions;

public class KvStateLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobId;
    private final JobVertexID jobVertexId;
    private final int numKeyGroups;
    private final String registrationName;
    private final KvStateID[] kvStateIds;
    private final KvStateServerAddress[] kvStateAddresses;
    private int numRegisteredKeyGroups;

    public KvStateLocation(JobID jobId, JobVertexID jobVertexId, int numKeyGroups, String registrationName) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId, (String)"JobID");
        this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId), (String)"JobVertexID"));
        Preconditions.checkArgument((numKeyGroups >= 0 ? 1 : 0) != 0, (Object)"Negative number of key groups");
        this.numKeyGroups = numKeyGroups;
        this.registrationName = (String)Preconditions.checkNotNull((Object)registrationName, (String)"Registration name");
        this.kvStateIds = new KvStateID[numKeyGroups];
        this.kvStateAddresses = new KvStateServerAddress[numKeyGroups];
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    public int getNumKeyGroups() {
        return this.numKeyGroups;
    }

    public String getRegistrationName() {
        return this.registrationName;
    }

    public int getNumRegisteredKeyGroups() {
        return this.numRegisteredKeyGroups;
    }

    public KvStateID getKvStateID(int keyGroupIndex) {
        if (keyGroupIndex < 0 || keyGroupIndex >= this.numKeyGroups) {
            throw new IndexOutOfBoundsException("Key group index");
        }
        return this.kvStateIds[keyGroupIndex];
    }

    public KvStateServerAddress getKvStateServerAddress(int keyGroupIndex) {
        if (keyGroupIndex < 0 || keyGroupIndex >= this.numKeyGroups) {
            throw new IndexOutOfBoundsException("Key group index");
        }
        return this.kvStateAddresses[keyGroupIndex];
    }

    void registerKvState(KeyGroupRange keyGroupRange, KvStateID kvStateId, KvStateServerAddress kvStateAddress) {
        if (keyGroupRange.getStartKeyGroup() < 0 || keyGroupRange.getEndKeyGroup() >= this.numKeyGroups) {
            throw new IndexOutOfBoundsException("Key group index");
        }
        for (int kgIdx = keyGroupRange.getStartKeyGroup(); kgIdx <= keyGroupRange.getEndKeyGroup(); ++kgIdx) {
            if (this.kvStateIds[kgIdx] == null && this.kvStateAddresses[kgIdx] == null) {
                ++this.numRegisteredKeyGroups;
            }
            this.kvStateIds[kgIdx] = kvStateId;
            this.kvStateAddresses[kgIdx] = kvStateAddress;
        }
    }

    void unregisterKvState(KeyGroupRange keyGroupRange) {
        if (keyGroupRange.getStartKeyGroup() < 0 || keyGroupRange.getEndKeyGroup() >= this.numKeyGroups) {
            throw new IndexOutOfBoundsException("Key group index");
        }
        for (int kgIdx = keyGroupRange.getStartKeyGroup(); kgIdx <= keyGroupRange.getEndKeyGroup(); ++kgIdx) {
            if (this.kvStateIds[kgIdx] == null || this.kvStateAddresses[kgIdx] == null) {
                throw new IllegalArgumentException("Not registered. Probably registration/unregistration race.");
            }
            --this.numRegisteredKeyGroups;
            this.kvStateIds[kgIdx] = null;
            this.kvStateAddresses[kgIdx] = null;
        }
    }

    public String toString() {
        return "KvStateLocation{jobId=" + this.jobId + ", jobVertexId=" + (Object)((Object)this.jobVertexId) + ", parallelism=" + this.numKeyGroups + ", kvStateIds=" + Arrays.toString((Object[])this.kvStateIds) + ", kvStateAddresses=" + Arrays.toString(this.kvStateAddresses) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvStateLocation that = (KvStateLocation)o;
        if (this.numKeyGroups != that.numKeyGroups) {
            return false;
        }
        if (!this.jobId.equals((Object)that.jobId)) {
            return false;
        }
        if (!this.jobVertexId.equals((Object)that.jobVertexId)) {
            return false;
        }
        if (!this.registrationName.equals(that.registrationName)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.kvStateIds, (Object[])that.kvStateIds)) {
            return false;
        }
        return Arrays.equals(this.kvStateAddresses, that.kvStateAddresses);
    }

    public int hashCode() {
        int result = this.jobId.hashCode();
        result = 31 * result + this.jobVertexId.hashCode();
        result = 31 * result + this.numKeyGroups;
        result = 31 * result + this.registrationName.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.kvStateIds);
        result = 31 * result + Arrays.hashCode(this.kvStateAddresses);
        return result;
    }
}

