/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerRunner
implements FatalErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerRunner.class);
    private final Object lock = new Object();
    private final ResourceManagerRuntimeServices resourceManagerRuntimeServices;
    private final ResourceManager<?> resourceManager;

    public ResourceManagerRunner(ResourceID resourceId, String resourceManagerEndpointId, Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry) throws Exception {
        Preconditions.checkNotNull((Object)resourceId);
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)rpcService);
        Preconditions.checkNotNull((Object)highAvailabilityServices);
        Preconditions.checkNotNull((Object)heartbeatServices);
        Preconditions.checkNotNull((Object)metricRegistry);
        ResourceManagerConfiguration resourceManagerConfiguration = ResourceManagerConfiguration.fromConfiguration(configuration);
        ResourceManagerRuntimeServicesConfiguration resourceManagerRuntimeServicesConfiguration = ResourceManagerRuntimeServicesConfiguration.fromConfiguration(configuration);
        this.resourceManagerRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration(resourceManagerRuntimeServicesConfiguration, highAvailabilityServices, rpcService.getScheduledExecutor());
        this.resourceManager = new StandaloneResourceManager(rpcService, resourceManagerEndpointId, resourceId, resourceManagerConfiguration, highAvailabilityServices, heartbeatServices, this.resourceManagerRuntimeServices.getSlotManager(), metricRegistry, this.resourceManagerRuntimeServices.getJobLeaderIdService(), this);
    }

    public void start() throws Exception {
        this.resourceManager.start();
    }

    public void shutDown() throws Exception {
        this.shutDownInternally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDownInternally() throws Exception {
        Exception exception = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.resourceManager.shutDown();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
            try {
                this.resourceManagerRuntimeServices.shutDown();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (exception != null) {
                ExceptionUtils.rethrow((Throwable)exception, (String)"Error while shutting down the resource manager runner.");
            }
        }
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Encountered fatal error.", exception);
        try {
            this.shutDownInternally();
        }
        catch (Exception e) {
            LOG.error("Could not properly shut down the resource manager.", (Throwable)e);
        }
    }
}

