/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredKeyedBackendStateMetaInfo<N, S> {
    private final StateDescriptor.Type stateType;
    private final String name;
    private final TypeSerializer<N> namespaceSerializer;
    private final TypeSerializer<S> stateSerializer;

    public RegisteredKeyedBackendStateMetaInfo(StateDescriptor.Type stateType, String name, TypeSerializer<N> namespaceSerializer, TypeSerializer<S> stateSerializer) {
        this.stateType = (StateDescriptor.Type)Preconditions.checkNotNull((Object)stateType);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.namespaceSerializer = (TypeSerializer)Preconditions.checkNotNull(namespaceSerializer);
        this.stateSerializer = (TypeSerializer)Preconditions.checkNotNull(stateSerializer);
    }

    public StateDescriptor.Type getStateType() {
        return this.stateType;
    }

    public String getName() {
        return this.name;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<S> getStateSerializer() {
        return this.stateSerializer;
    }

    public Snapshot<N, S> snapshot() {
        return new Snapshot(this.stateType, this.name, this.namespaceSerializer.duplicate(), this.stateSerializer.duplicate(), this.namespaceSerializer.snapshotConfiguration(), this.stateSerializer.snapshotConfiguration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredKeyedBackendStateMetaInfo that = (RegisteredKeyedBackendStateMetaInfo)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getStateSerializer().equals(that.getStateSerializer()) && this.getNamespaceSerializer().equals(that.getNamespaceSerializer());
    }

    public String toString() {
        return "RegisteredKeyedBackendStateMetaInfo{stateType=" + this.stateType + ", name='" + this.name + '\'' + ", namespaceSerializer=" + this.namespaceSerializer + ", stateSerializer=" + this.stateSerializer + '}';
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getStateSerializer().hashCode();
        return result;
    }

    public static class Snapshot<N, S> {
        private StateDescriptor.Type stateType;
        private String name;
        private TypeSerializer<N> namespaceSerializer;
        private TypeSerializer<S> stateSerializer;
        private TypeSerializerConfigSnapshot namespaceSerializerConfigSnapshot;
        private TypeSerializerConfigSnapshot stateSerializerConfigSnapshot;

        Snapshot() {
        }

        private Snapshot(StateDescriptor.Type stateType, String name, TypeSerializer<N> namespaceSerializer, TypeSerializer<S> stateSerializer, TypeSerializerConfigSnapshot namespaceSerializerConfigSnapshot, TypeSerializerConfigSnapshot stateSerializerConfigSnapshot) {
            this.stateType = (StateDescriptor.Type)Preconditions.checkNotNull((Object)stateType);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.namespaceSerializer = (TypeSerializer)Preconditions.checkNotNull(namespaceSerializer);
            this.stateSerializer = (TypeSerializer)Preconditions.checkNotNull(stateSerializer);
            this.namespaceSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)namespaceSerializerConfigSnapshot);
            this.stateSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)stateSerializerConfigSnapshot);
        }

        public StateDescriptor.Type getStateType() {
            return this.stateType;
        }

        void setStateType(StateDescriptor.Type stateType) {
            this.stateType = stateType;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public TypeSerializer<N> getNamespaceSerializer() {
            return this.namespaceSerializer;
        }

        void setNamespaceSerializer(TypeSerializer<N> namespaceSerializer) {
            this.namespaceSerializer = namespaceSerializer;
        }

        public TypeSerializer<S> getStateSerializer() {
            return this.stateSerializer;
        }

        void setStateSerializer(TypeSerializer<S> stateSerializer) {
            this.stateSerializer = stateSerializer;
        }

        public TypeSerializerConfigSnapshot getNamespaceSerializerConfigSnapshot() {
            return this.namespaceSerializerConfigSnapshot;
        }

        void setNamespaceSerializerConfigSnapshot(TypeSerializerConfigSnapshot namespaceSerializerConfigSnapshot) {
            this.namespaceSerializerConfigSnapshot = namespaceSerializerConfigSnapshot;
        }

        public TypeSerializerConfigSnapshot getStateSerializerConfigSnapshot() {
            return this.stateSerializerConfigSnapshot;
        }

        void setStateSerializerConfigSnapshot(TypeSerializerConfigSnapshot stateSerializerConfigSnapshot) {
            this.stateSerializerConfigSnapshot = stateSerializerConfigSnapshot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot that = (Snapshot)o;
            if (!this.stateType.equals((Object)that.stateType)) {
                return false;
            }
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return (this.getStateSerializer() == null && that.getStateSerializer() == null || this.getStateSerializer().equals(that.getStateSerializer())) && (this.getNamespaceSerializer() == null && that.getNamespaceSerializer() == null || this.getNamespaceSerializer().equals(that.getNamespaceSerializer())) && (this.getNamespaceSerializerConfigSnapshot() == null && that.getNamespaceSerializerConfigSnapshot() == null || this.getNamespaceSerializerConfigSnapshot().equals((Object)that.getNamespaceSerializerConfigSnapshot())) && (this.getStateSerializerConfigSnapshot() == null && that.getStateSerializerConfigSnapshot() == null || this.getStateSerializerConfigSnapshot().equals((Object)that.getStateSerializerConfigSnapshot()));
        }

        public int hashCode() {
            int result = this.getName().hashCode();
            result = 31 * result + this.getStateType().hashCode();
            result = 31 * result + (this.getNamespaceSerializer() != null ? this.getNamespaceSerializer().hashCode() : 0);
            result = 31 * result + (this.getStateSerializer() != null ? this.getStateSerializer().hashCode() : 0);
            result = 31 * result + (this.getNamespaceSerializerConfigSnapshot() != null ? this.getNamespaceSerializerConfigSnapshot().hashCode() : 0);
            result = 31 * result + (this.getStateSerializerConfigSnapshot() != null ? this.getStateSerializerConfigSnapshot().hashCode() : 0);
            return result;
        }
    }
}

