/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.util.Preconditions;

public class RegisteredOperatorBackendStateMetaInfo<S> {
    private final String name;
    private final OperatorStateHandle.Mode assignmentMode;
    private final TypeSerializer<S> partitionStateSerializer;

    public RegisteredOperatorBackendStateMetaInfo(String name, TypeSerializer<S> partitionStateSerializer, OperatorStateHandle.Mode assignmentMode) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.partitionStateSerializer = (TypeSerializer)Preconditions.checkNotNull(partitionStateSerializer);
        this.assignmentMode = (OperatorStateHandle.Mode)((Object)Preconditions.checkNotNull((Object)((Object)assignmentMode)));
    }

    public String getName() {
        return this.name;
    }

    public OperatorStateHandle.Mode getAssignmentMode() {
        return this.assignmentMode;
    }

    public TypeSerializer<S> getPartitionStateSerializer() {
        return this.partitionStateSerializer;
    }

    public Snapshot<S> snapshot() {
        return new Snapshot(this.name, this.assignmentMode, this.partitionStateSerializer.duplicate(), this.partitionStateSerializer.snapshotConfiguration());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof RegisteredOperatorBackendStateMetaInfo && this.name.equals(((RegisteredOperatorBackendStateMetaInfo)obj).getName()) && this.assignmentMode.equals((Object)((RegisteredOperatorBackendStateMetaInfo)obj).getAssignmentMode()) && this.partitionStateSerializer.equals(((RegisteredOperatorBackendStateMetaInfo)obj).getPartitionStateSerializer());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getAssignmentMode().hashCode();
        result = 31 * result + this.getPartitionStateSerializer().hashCode();
        return result;
    }

    public String toString() {
        return "RegisteredOperatorBackendStateMetaInfo{name='" + this.name + "', assignmentMode=" + (Object)((Object)this.assignmentMode) + ", partitionStateSerializer=" + this.partitionStateSerializer + '}';
    }

    public static class Snapshot<S> {
        private String name;
        private OperatorStateHandle.Mode assignmentMode;
        private TypeSerializer<S> partitionStateSerializer;
        private TypeSerializerConfigSnapshot partitionStateSerializerConfigSnapshot;

        Snapshot() {
        }

        private Snapshot(String name, OperatorStateHandle.Mode assignmentMode, TypeSerializer<S> partitionStateSerializer, TypeSerializerConfigSnapshot partitionStateSerializerConfigSnapshot) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.assignmentMode = (OperatorStateHandle.Mode)((Object)Preconditions.checkNotNull((Object)((Object)assignmentMode)));
            this.partitionStateSerializer = (TypeSerializer)Preconditions.checkNotNull(partitionStateSerializer);
            this.partitionStateSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)partitionStateSerializerConfigSnapshot);
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public OperatorStateHandle.Mode getAssignmentMode() {
            return this.assignmentMode;
        }

        void setAssignmentMode(OperatorStateHandle.Mode assignmentMode) {
            this.assignmentMode = assignmentMode;
        }

        public TypeSerializer<S> getPartitionStateSerializer() {
            return this.partitionStateSerializer;
        }

        void setPartitionStateSerializer(TypeSerializer<S> partitionStateSerializer) {
            this.partitionStateSerializer = partitionStateSerializer;
        }

        public TypeSerializerConfigSnapshot getPartitionStateSerializerConfigSnapshot() {
            return this.partitionStateSerializerConfigSnapshot;
        }

        void setPartitionStateSerializerConfigSnapshot(TypeSerializerConfigSnapshot partitionStateSerializerConfigSnapshot) {
            this.partitionStateSerializerConfigSnapshot = partitionStateSerializerConfigSnapshot;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof Snapshot && this.name.equals(((Snapshot)obj).getName()) && this.assignmentMode.equals((Object)((Snapshot)obj).getAssignmentMode()) && (this.partitionStateSerializer == null && ((Snapshot)obj).getPartitionStateSerializer() == null || this.partitionStateSerializer.equals(((Snapshot)obj).getPartitionStateSerializer())) && (this.partitionStateSerializerConfigSnapshot == null && ((Snapshot)obj).getPartitionStateSerializerConfigSnapshot() == null || this.partitionStateSerializerConfigSnapshot.equals((Object)((Snapshot)obj).getPartitionStateSerializerConfigSnapshot()));
        }

        public int hashCode() {
            int result = this.getName().hashCode();
            result = 31 * result + this.getAssignmentMode().hashCode();
            result = 31 * result + (this.getPartitionStateSerializer() != null ? this.getPartitionStateSerializer().hashCode() : 0);
            result = 31 * result + (this.getPartitionStateSerializerConfigSnapshot() != null ? this.getPartitionStateSerializerConfigSnapshot().hashCode() : 0);
            return result;
        }
    }
}

