/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

public class MemCheckpointStreamFactory
implements CheckpointStreamFactory {
    private final int maxStateSize;

    public MemCheckpointStreamFactory(int maxStateSize) {
        this.maxStateSize = maxStateSize;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public CheckpointStreamFactory.CheckpointStateOutputStream createCheckpointStateOutputStream(long checkpointID, long timestamp) throws Exception {
        return new MemoryCheckpointOutputStream(this.maxStateSize);
    }

    public String toString() {
        return "In-Memory Stream Factory";
    }

    static void checkSize(int size, int maxSize) throws IOException {
        if (size > maxSize) {
            throw new IOException("Size of the state is larger than the maximum permitted memory-backed state. Size=" + size + " , maxSize=" + maxSize + " . Consider using a different state backend, like the File System State backend.");
        }
    }

    public static class MemoryCheckpointOutputStream
    extends CheckpointStreamFactory.CheckpointStateOutputStream {
        private final ByteArrayOutputStreamWithPos os = new ByteArrayOutputStreamWithPos();
        private final int maxSize;
        private AtomicBoolean closed;
        boolean isEmpty = true;

        public MemoryCheckpointOutputStream(int maxSize) {
            this.maxSize = maxSize;
            this.closed = new AtomicBoolean(false);
        }

        public void write(int b) throws IOException {
            this.os.write(b);
            this.isEmpty = false;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.isEmpty = false;
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void sync() throws IOException {
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.closeInternal();
            }
        }

        @Override
        public StreamStateHandle closeAndGetHandle() throws IOException {
            if (this.isEmpty) {
                return null;
            }
            return new ByteStreamStateHandle(String.valueOf(UUID.randomUUID()), this.closeAndGetBytes());
        }

        public long getPos() throws IOException {
            return this.os.getPosition();
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public byte[] closeAndGetBytes() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                MemCheckpointStreamFactory.checkSize(this.os.size(), this.maxSize);
                byte[] bytes = this.os.toByteArray();
                this.closeInternal();
                return bytes;
            }
            throw new IOException("stream has already been closed");
        }

        private void closeInternal() {
            this.os.reset();
        }
    }
}

