/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskexecutor.utils.TaskExecutorMetricsInitializer;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerRunner
implements FatalErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerRunner.class);
    private final Object lock = new Object();
    private final Configuration configuration;
    private final ResourceID resourceID;
    private final RpcService rpcService;
    private final HighAvailabilityServices highAvailabilityServices;
    private final Executor executor;
    private final TaskExecutor taskManager;

    public TaskManagerRunner(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry) throws Exception {
        this(configuration, resourceID, rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, false);
    }

    public TaskManagerRunner(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, boolean localCommunicationOnly) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.highAvailabilityServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)highAvailabilityServices);
        this.executor = rpcService.getExecutor();
        InetAddress remoteAddress = InetAddress.getByName(rpcService.getAddress());
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, remoteAddress, localCommunicationOnly);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID);
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration);
        TaskManagerMetricGroup taskManagerMetricGroup = new TaskManagerMetricGroup(metricRegistry, taskManagerServices.getTaskManagerLocation().getHostname(), resourceID.toString());
        TaskExecutorMetricsInitializer.instantiateStatusMetrics(taskManagerMetricGroup, taskManagerServices.getNetworkEnvironment());
        this.taskManager = new TaskExecutor(rpcService, taskManagerConfiguration, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), highAvailabilityServices, heartbeatServices, metricRegistry, taskManagerMetricGroup, taskManagerServices.getBroadcastVariableManager(), taskManagerServices.getFileCache(), taskManagerServices.getTaskSlotTable(), taskManagerServices.getJobManagerTable(), taskManagerServices.getJobLeaderService(), this);
    }

    public void start() throws Exception {
        this.taskManager.start();
    }

    public void shutDown(Throwable cause) {
        this.shutDownInternally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDownInternally() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.taskManager.shutDown();
            }
            catch (Exception e) {
                LOG.error("Could not properly shut down the task manager.", (Throwable)e);
            }
        }
    }

    public Future<Void> getTerminationFuture() {
        return this.taskManager.getTerminationFuture();
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred while executing the TaskManager. Shutting it down...", exception);
        this.shutDown(exception);
    }

    public static RpcService createRpcService(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)haServices);
        String taskManagerHostname = configuration.getString("taskmanager.hostname", null);
        if (taskManagerHostname != null) {
            LOG.info("Using configured hostname/address for TaskManager: {}.", (Object)taskManagerHostname);
        } else {
            Time lookupTimeout = Time.milliseconds((long)AkkaUtils.getLookupTimeout(configuration).toMillis());
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(haServices.getResourceManagerLeaderRetriever(), lookupTimeout);
            taskManagerHostname = taskManagerAddress.getHostName();
            LOG.info("TaskManager will use hostname/address '{}' ({}) for communication.", (Object)taskManagerHostname, (Object)taskManagerAddress.getHostAddress());
        }
        int rpcPort = configuration.getInteger("taskmanager.rpc.port", 0);
        Preconditions.checkState((rpcPort >= 0 && rpcPort <= 65535 ? 1 : 0) != 0, (String)"Invalid value for '%s' (port for the TaskManager actor system) : %d - Leave config parameter empty or use 0 to let the system choose port automatically.", (Object[])new Object[]{"taskmanager.rpc.port", rpcPort});
        return AkkaRpcServiceUtils.createRpcService(taskManagerHostname, rpcPort, configuration);
    }
}

