/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.framework.recipes.queue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.MultiItem;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.QueueSerializer;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;

class ItemSerializer {
    private static final int VERSION = 65537;
    private static final byte ITEM_OPCODE = 1;
    private static final byte EOF_OPCODE = 2;
    private static final int INITIAL_BUFFER_SIZE = 4096;

    static <T> MultiItem<T> deserialize(byte[] bytes, QueueSerializer<T> serializer) throws Exception {
        byte opcode;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        int version = in.readInt();
        if (version != 65537) {
            throw new IOException(String.format("Incorrect version. Expected %d - Found: %d", 65537, version));
        }
        ArrayList<T> items = Lists.newArrayList();
        while ((opcode = in.readByte()) != 2) {
            if (opcode != 1) {
                throw new IOException(String.format("Incorrect opcode. Expected %d - Found: %d", (byte)1, opcode));
            }
            int size = in.readInt();
            if (size < 0) {
                throw new IOException(String.format("Bad size: %d", size));
            }
            byte[] itemBytes = new byte[size];
            if (size > 0) {
                in.readFully(itemBytes);
            }
            items.add(serializer.deserialize(itemBytes));
        }
        final Iterator iterator = items.iterator();
        return new MultiItem<T>(){

            @Override
            public T nextItem() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    static <T> byte[] serialize(MultiItem<T> items, QueueSerializer<T> serializer) throws Exception {
        T item;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(4096);
        DataOutputStream out = new DataOutputStream(bytes);
        out.writeInt(65537);
        while ((item = items.nextItem()) != null) {
            byte[] itemBytes = serializer.serialize(item);
            out.writeByte(1);
            out.writeInt(itemBytes.length);
            if (itemBytes.length <= 0) continue;
            out.write(itemBytes);
        }
        out.writeByte(2);
        out.close();
        return bytes.toByteArray();
    }

    private ItemSerializer() {
    }
}

