/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfoWithHistory;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.UpperLimitExceptionParameter;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.curator4.com.google.common.collect.Iterables;
import org.apache.flink.util.Preconditions;

public class JobExceptionsHandler
extends AbstractExecutionGraphHandler<JobExceptionsInfoWithHistory, JobExceptionsMessageParameters>
implements JsonArchivist {
    static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 20;

    public JobExceptionsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobExceptionsInfoWithHistory, JobExceptionsMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobExceptionsInfoWithHistory handleRequest(HandlerRequest<EmptyRequestBody, JobExceptionsMessageParameters> request, ExecutionGraphInfo executionGraph) {
        List exceptionToReportMaxSizes = request.getQueryParameter(UpperLimitExceptionParameter.class);
        int exceptionToReportMaxSize = exceptionToReportMaxSizes.size() > 0 ? (Integer)exceptionToReportMaxSizes.get(0) : 20;
        return JobExceptionsHandler.createJobExceptionsInfo(executionGraph, exceptionToReportMaxSize);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(ExecutionGraphInfo executionGraphInfo) throws IOException {
        JobExceptionsInfoWithHistory json = JobExceptionsHandler.createJobExceptionsInfo(executionGraphInfo, 20);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", executionGraphInfo.getJobId().toString());
        return Collections.singletonList(new ArchivedJson(path, json));
    }

    private static JobExceptionsInfoWithHistory createJobExceptionsInfo(ExecutionGraphInfo executionGraphInfo, int exceptionToReportMaxSize) {
        ArchivedExecutionGraph executionGraph = executionGraphInfo.getArchivedExecutionGraph();
        if (executionGraph.getFailureInfo() == null) {
            return new JobExceptionsInfoWithHistory();
        }
        ArrayList<JobExceptionsInfo.ExecutionExceptionInfo> taskExceptionList = new ArrayList<JobExceptionsInfo.ExecutionExceptionInfo>();
        boolean truncated = false;
        for (AccessExecutionVertex accessExecutionVertex : executionGraph.getAllExecutionVertices()) {
            Optional<ErrorInfo> failure = accessExecutionVertex.getFailureInfo();
            if (!failure.isPresent()) continue;
            if (taskExceptionList.size() >= exceptionToReportMaxSize) {
                truncated = true;
                break;
            }
            TaskManagerLocation location = accessExecutionVertex.getCurrentAssignedResourceLocation();
            String locationString = JobExceptionsHandler.toString(location);
            long timestamp = accessExecutionVertex.getStateTimestamp(ExecutionState.FAILED);
            taskExceptionList.add(new JobExceptionsInfo.ExecutionExceptionInfo(failure.get().getExceptionAsString(), accessExecutionVertex.getTaskNameWithSubtaskIndex(), locationString, timestamp == 0L ? -1L : timestamp));
        }
        ErrorInfo rootCause = executionGraph.getFailureInfo();
        return new JobExceptionsInfoWithHistory(rootCause.getExceptionAsString(), rootCause.getTimestamp(), taskExceptionList, truncated, JobExceptionsHandler.createJobExceptionHistory(executionGraphInfo.getExceptionHistory(), exceptionToReportMaxSize));
    }

    private static JobExceptionsInfoWithHistory.JobExceptionHistory createJobExceptionHistory(Iterable<RootExceptionHistoryEntry> historyEntries, int limit) {
        ArrayList reversedHistoryEntries = new ArrayList();
        Iterables.addAll(reversedHistoryEntries, historyEntries);
        Collections.reverse(reversedHistoryEntries);
        List<JobExceptionsInfoWithHistory.RootExceptionInfo> exceptionHistoryEntries = reversedHistoryEntries.stream().limit(limit).map(JobExceptionsHandler::createRootExceptionInfo).collect(Collectors.toList());
        return new JobExceptionsInfoWithHistory.JobExceptionHistory(exceptionHistoryEntries, exceptionHistoryEntries.size() < reversedHistoryEntries.size());
    }

    private static JobExceptionsInfoWithHistory.RootExceptionInfo createRootExceptionInfo(RootExceptionHistoryEntry historyEntry) {
        List<JobExceptionsInfoWithHistory.ExceptionInfo> concurrentExceptions = StreamSupport.stream(historyEntry.getConcurrentExceptions().spliterator(), false).map(JobExceptionsHandler::createExceptionInfo).collect(Collectors.toList());
        if (historyEntry.isGlobal()) {
            return new JobExceptionsInfoWithHistory.RootExceptionInfo(historyEntry.getException().getOriginalErrorClassName(), historyEntry.getExceptionAsString(), historyEntry.getTimestamp(), concurrentExceptions);
        }
        JobExceptionsHandler.assertLocalExceptionInfo(historyEntry);
        return new JobExceptionsInfoWithHistory.RootExceptionInfo(historyEntry.getException().getOriginalErrorClassName(), historyEntry.getExceptionAsString(), historyEntry.getTimestamp(), historyEntry.getFailingTaskName(), JobExceptionsHandler.toString(historyEntry.getTaskManagerLocation()), concurrentExceptions);
    }

    private static JobExceptionsInfoWithHistory.ExceptionInfo createExceptionInfo(ExceptionHistoryEntry exceptionHistoryEntry) {
        JobExceptionsHandler.assertLocalExceptionInfo(exceptionHistoryEntry);
        return new JobExceptionsInfoWithHistory.ExceptionInfo(exceptionHistoryEntry.getException().getOriginalErrorClassName(), exceptionHistoryEntry.getExceptionAsString(), exceptionHistoryEntry.getTimestamp(), exceptionHistoryEntry.getFailingTaskName(), JobExceptionsHandler.toString(exceptionHistoryEntry.getTaskManagerLocation()));
    }

    private static void assertLocalExceptionInfo(ExceptionHistoryEntry exceptionHistoryEntry) {
        Preconditions.checkArgument((exceptionHistoryEntry.getFailingTaskName() != null ? 1 : 0) != 0, (Object)"The taskName must not be null for a non-global failure.");
        Preconditions.checkArgument((exceptionHistoryEntry.getTaskManagerLocation() != null ? 1 : 0) != 0, (Object)"The location must not be null for a non-global failure.");
    }

    @VisibleForTesting
    static String toString(@Nullable TaskManagerLocation location) {
        return location != null ? JobExceptionsHandler.taskManagerLocationToString(location.getFQDNHostname(), location.dataPort()) : "(unassigned)";
    }

    @Nullable
    @VisibleForTesting
    static String toString(@Nullable ExceptionHistoryEntry.ArchivedTaskManagerLocation location) {
        return location != null ? JobExceptionsHandler.taskManagerLocationToString(location.getFQDNHostname(), location.getPort()) : null;
    }

    private static String taskManagerLocationToString(String fqdnHostname, int port) {
        return String.format("%s:%d", fqdnHostname, port);
    }
}

