/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.GlobalModVersionMismatch;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.executiongraph.SlotProviderStrategy;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.LocationPreferenceConstraint;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;

public class ExecutionVertex
implements AccessExecutionVertex,
Archiveable<ArchivedExecutionVertex> {
    private static final Logger LOG = ExecutionGraph.LOG;
    public static final int MAX_DISTINCT_LOCATIONS_TO_CONSIDER = 8;
    private final ExecutionJobVertex jobVertex;
    private final Map<IntermediateResultPartitionID, IntermediateResultPartition> resultPartitions;
    private final ExecutionEdge[][] inputEdges;
    private final int subTaskIndex;
    private final ExecutionVertexID executionVertexId;
    private final EvictingBoundedList<ArchivedExecution> priorExecutions;
    private final Time timeout;
    private final String taskNameWithSubtask;
    private CoLocationConstraint locationConstraint;
    private Execution currentExecution;
    private final ArrayList<InputSplit> inputSplits;

    ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, Time timeout, long initialGlobalModVersion, long createTimestamp, int maxPriorExecutionHistoryLength) {
        this.jobVertex = jobVertex;
        this.subTaskIndex = subTaskIndex;
        this.executionVertexId = new ExecutionVertexID(jobVertex.getJobVertexId(), subTaskIndex);
        this.taskNameWithSubtask = String.format("%s (%d/%d)", jobVertex.getJobVertex().getName(), subTaskIndex + 1, jobVertex.getParallelism());
        this.resultPartitions = new LinkedHashMap<IntermediateResultPartitionID, IntermediateResultPartition>(producedDataSets.length, 1.0f);
        for (IntermediateResult result : producedDataSets) {
            IntermediateResultPartition irp = new IntermediateResultPartition(result, this, subTaskIndex);
            result.setPartition(subTaskIndex, irp);
            this.resultPartitions.put(irp.getPartitionId(), irp);
        }
        this.inputEdges = new ExecutionEdge[jobVertex.getJobVertex().getInputs().size()][];
        this.priorExecutions = new EvictingBoundedList(maxPriorExecutionHistoryLength);
        this.currentExecution = new Execution(this.getExecutionGraph().getFutureExecutor(), this, 0, initialGlobalModVersion, createTimestamp, timeout);
        CoLocationGroup clg = jobVertex.getCoLocationGroup();
        this.locationConstraint = clg != null ? clg.getLocationConstraint(subTaskIndex) : null;
        this.getExecutionGraph().registerExecution(this.currentExecution);
        this.timeout = timeout;
        this.inputSplits = new ArrayList();
    }

    public JobID getJobId() {
        return this.jobVertex.getJobId();
    }

    public ExecutionJobVertex getJobVertex() {
        return this.jobVertex;
    }

    public JobVertexID getJobvertexId() {
        return this.jobVertex.getJobVertexId();
    }

    public String getTaskName() {
        return this.jobVertex.getJobVertex().getName();
    }

    @Override
    public String getTaskNameWithSubtaskIndex() {
        return this.taskNameWithSubtask;
    }

    public int getTotalNumberOfParallelSubtasks() {
        return this.jobVertex.getParallelism();
    }

    public int getMaxParallelism() {
        return this.jobVertex.getMaxParallelism();
    }

    public ResourceProfile getResourceProfile() {
        return this.jobVertex.getResourceProfile();
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    public ExecutionVertexID getID() {
        return this.executionVertexId;
    }

    public int getNumberOfInputs() {
        return this.inputEdges.length;
    }

    public ExecutionEdge[] getInputEdges(int input) {
        if (input < 0 || input >= this.inputEdges.length) {
            throw new IllegalArgumentException(String.format("Input %d is out of range [0..%d)", input, this.inputEdges.length));
        }
        return this.inputEdges[input];
    }

    public ExecutionEdge[][] getAllInputEdges() {
        return this.inputEdges;
    }

    public CoLocationConstraint getLocationConstraint() {
        return this.locationConstraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSplit getNextInputSplit(String host) {
        int taskId = this.getParallelSubtaskIndex();
        ArrayList<InputSplit> arrayList = this.inputSplits;
        synchronized (arrayList) {
            InputSplit nextInputSplit = this.jobVertex.getSplitAssigner().getNextInputSplit(host, taskId);
            if (nextInputSplit != null) {
                this.inputSplits.add(nextInputSplit);
            }
            return nextInputSplit;
        }
    }

    @Override
    public Execution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.currentExecution.getState();
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.currentExecution.getStateTimestamp(state);
    }

    @Override
    public String getFailureCauseAsString() {
        return ExceptionUtils.stringifyException((Throwable)this.getFailureCause());
    }

    public Throwable getFailureCause() {
        return this.currentExecution.getFailureCause();
    }

    public CompletableFuture<TaskManagerLocation> getCurrentTaskManagerLocationFuture() {
        return this.currentExecution.getTaskManagerLocationFuture();
    }

    public LogicalSlot getCurrentAssignedResource() {
        return this.currentExecution.getAssignedResource();
    }

    @Override
    public TaskManagerLocation getCurrentAssignedResourceLocation() {
        return this.currentExecution.getAssignedResourceLocation();
    }

    @Override
    @Nullable
    public ArchivedExecution getPriorExecutionAttempt(int attemptNumber) {
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            if (attemptNumber >= 0 && attemptNumber < this.priorExecutions.size()) {
                return this.priorExecutions.get(attemptNumber);
            }
            throw new IllegalArgumentException("attempt does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivedExecution getLatestPriorExecution() {
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            int size = this.priorExecutions.size();
            if (size > 0) {
                return this.priorExecutions.get(size - 1);
            }
            return null;
        }
    }

    public TaskManagerLocation getLatestPriorLocation() {
        ArchivedExecution latestPriorExecution = this.getLatestPriorExecution();
        return latestPriorExecution != null ? latestPriorExecution.getAssignedResourceLocation() : null;
    }

    public AllocationID getLatestPriorAllocation() {
        ArchivedExecution latestPriorExecution = this.getLatestPriorExecution();
        return latestPriorExecution != null ? latestPriorExecution.getAssignedAllocationID() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EvictingBoundedList<ArchivedExecution> getCopyOfPriorExecutionsList() {
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            return new EvictingBoundedList<ArchivedExecution>(this.priorExecutions);
        }
    }

    public ExecutionGraph getExecutionGraph() {
        return this.jobVertex.getGraph();
    }

    public Map<IntermediateResultPartitionID, IntermediateResultPartition> getProducedPartitions() {
        return this.resultPartitions;
    }

    public InputDependencyConstraint getInputDependencyConstraint() {
        return this.getJobVertex().getInputDependencyConstraint();
    }

    public void connectSource(int inputNumber, IntermediateResult source, JobEdge edge, int consumerNumber) {
        ExecutionEdge[] edges;
        DistributionPattern pattern = edge.getDistributionPattern();
        IntermediateResultPartition[] sourcePartitions = source.getPartitions();
        switch (pattern) {
            case POINTWISE: {
                edges = this.connectPointwise(sourcePartitions, inputNumber);
                break;
            }
            case ALL_TO_ALL: {
                edges = this.connectAllToAll(sourcePartitions, inputNumber);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized distribution pattern.");
            }
        }
        this.inputEdges[inputNumber] = edges;
        for (ExecutionEdge ee : edges) {
            ee.getSource().addConsumer(ee, consumerNumber);
        }
    }

    private ExecutionEdge[] connectAllToAll(IntermediateResultPartition[] sourcePartitions, int inputNumber) {
        ExecutionEdge[] edges = new ExecutionEdge[sourcePartitions.length];
        for (int i = 0; i < sourcePartitions.length; ++i) {
            IntermediateResultPartition irp = sourcePartitions[i];
            edges[i] = new ExecutionEdge(irp, this, inputNumber);
        }
        return edges;
    }

    private ExecutionEdge[] connectPointwise(IntermediateResultPartition[] sourcePartitions, int inputNumber) {
        int numSources = sourcePartitions.length;
        int parallelism = this.getTotalNumberOfParallelSubtasks();
        if (numSources == parallelism) {
            return new ExecutionEdge[]{new ExecutionEdge(sourcePartitions[this.subTaskIndex], this, inputNumber)};
        }
        if (numSources < parallelism) {
            int sourcePartition;
            if (parallelism % numSources == 0) {
                int factor = parallelism / numSources;
                sourcePartition = this.subTaskIndex / factor;
            } else {
                float factor = (float)parallelism / (float)numSources;
                sourcePartition = (int)((float)this.subTaskIndex / factor);
            }
            return new ExecutionEdge[]{new ExecutionEdge(sourcePartitions[sourcePartition], this, inputNumber)};
        }
        if (numSources % parallelism == 0) {
            int factor = numSources / parallelism;
            int startIndex = this.subTaskIndex * factor;
            ExecutionEdge[] edges = new ExecutionEdge[factor];
            for (int i = 0; i < factor; ++i) {
                edges[i] = new ExecutionEdge(sourcePartitions[startIndex + i], this, inputNumber);
            }
            return edges;
        }
        float factor = (float)numSources / (float)parallelism;
        int start = (int)((float)this.subTaskIndex * factor);
        int end = this.subTaskIndex == this.getTotalNumberOfParallelSubtasks() - 1 ? sourcePartitions.length : (int)((float)(this.subTaskIndex + 1) * factor);
        ExecutionEdge[] edges = new ExecutionEdge[end - start];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = new ExecutionEdge(sourcePartitions[start + i], this, inputNumber);
        }
        return edges;
    }

    public Collection<CompletableFuture<TaskManagerLocation>> getPreferredLocations() {
        Collection<CompletableFuture<TaskManagerLocation>> basedOnState = this.getPreferredLocationsBasedOnState();
        return basedOnState != null ? basedOnState : this.getPreferredLocationsBasedOnInputs();
    }

    public Collection<CompletableFuture<TaskManagerLocation>> getPreferredLocationsBasedOnState() {
        TaskManagerLocation priorLocation;
        if (this.currentExecution.getTaskRestore() != null && (priorLocation = this.getLatestPriorLocation()) != null) {
            return Collections.singleton(CompletableFuture.completedFuture(priorLocation));
        }
        return null;
    }

    public Optional<TaskManagerLocation> getPreferredLocationBasedOnState() {
        if (this.currentExecution.getTaskRestore() != null) {
            return Optional.ofNullable(this.getLatestPriorLocation());
        }
        return Optional.empty();
    }

    public Collection<CompletableFuture<TaskManagerLocation>> getPreferredLocationsBasedOnInputs() {
        if (this.inputEdges == null) {
            return Collections.emptySet();
        }
        HashSet locations = new HashSet(this.getTotalNumberOfParallelSubtasks());
        HashSet<CompletableFuture<TaskManagerLocation>> inputLocations = new HashSet<CompletableFuture<TaskManagerLocation>>(this.getTotalNumberOfParallelSubtasks());
        for (int i = 0; i < this.inputEdges.length; ++i) {
            inputLocations.clear();
            ExecutionEdge[] sources = this.inputEdges[i];
            if (sources != null) {
                for (int k = 0; k < sources.length; ++k) {
                    CompletableFuture<TaskManagerLocation> locationFuture = sources[k].getSource().getProducer().getCurrentTaskManagerLocationFuture();
                    inputLocations.add(locationFuture);
                    if (inputLocations.size() <= 8) continue;
                    inputLocations.clear();
                    break;
                }
            }
            if (!locations.isEmpty() && (inputLocations.isEmpty() || inputLocations.size() >= locations.size())) continue;
            locations.clear();
            locations.addAll(inputLocations);
        }
        return locations.isEmpty() ? Collections.emptyList() : locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Execution resetForNewExecution(long timestamp, long originatingGlobalModVersion) throws GlobalModVersionMismatch {
        LOG.debug("Resetting execution vertex {} for new execution.", (Object)this.getTaskNameWithSubtaskIndex());
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            long actualModVersion = this.getExecutionGraph().getGlobalModVersion();
            if (actualModVersion > originatingGlobalModVersion) {
                throw new GlobalModVersionMismatch(originatingGlobalModVersion, actualModVersion);
            }
            return this.resetForNewExecutionInternal(timestamp, originatingGlobalModVersion);
        }
    }

    public void resetForNewExecution() {
        this.resetForNewExecutionInternal(System.currentTimeMillis(), this.getExecutionGraph().getGlobalModVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Execution resetForNewExecutionInternal(long timestamp, long originatingGlobalModVersion) {
        Execution oldExecution = this.currentExecution;
        ExecutionState oldState = oldExecution.getState();
        if (oldState.isTerminal()) {
            Execution newExecution;
            if (oldState == ExecutionState.FINISHED) {
                oldExecution.handlePartitionCleanup(false, true);
                this.getExecutionGraph().getPartitionReleaseStrategy().vertexUnfinished(this.executionVertexId);
            }
            this.priorExecutions.add(oldExecution.archive());
            this.currentExecution = newExecution = new Execution(this.getExecutionGraph().getFutureExecutor(), this, oldExecution.getAttemptNumber() + 1, originatingGlobalModVersion, timestamp, this.timeout);
            ArrayList<InputSplit> arrayList = this.inputSplits;
            synchronized (arrayList) {
                InputSplitAssigner assigner = this.jobVertex.getSplitAssigner();
                if (assigner != null) {
                    assigner.returnInputSplit(this.inputSplits, this.getParallelSubtaskIndex());
                    this.inputSplits.clear();
                }
            }
            CoLocationGroup grp = this.jobVertex.getCoLocationGroup();
            if (grp != null) {
                this.locationConstraint = grp.getLocationConstraint(this.subTaskIndex);
            }
            this.getExecutionGraph().registerExecution(newExecution);
            if (oldState == ExecutionState.FINISHED) {
                this.getExecutionGraph().vertexUnFinished();
            }
            for (IntermediateResultPartition resultPartition : this.resultPartitions.values()) {
                resultPartition.resetForNewExecution();
            }
            return newExecution;
        }
        throw new IllegalStateException("Cannot reset a vertex that is in non-terminal state " + (Object)((Object)oldState));
    }

    public CompletableFuture<Void> scheduleForExecution(SlotProviderStrategy slotProviderStrategy, LocationPreferenceConstraint locationPreferenceConstraint, @Nonnull Set<AllocationID> allPreviousExecutionGraphAllocationIds) {
        return this.currentExecution.scheduleForExecution(slotProviderStrategy, locationPreferenceConstraint, allPreviousExecutionGraphAllocationIds);
    }

    public void tryAssignResource(LogicalSlot slot) {
        if (!this.currentExecution.tryAssignResource(slot)) {
            throw new IllegalStateException("Could not assign resource " + slot + " to current execution " + this.currentExecution + '.');
        }
    }

    public void deploy() throws JobException {
        this.currentExecution.deploy();
    }

    @VisibleForTesting
    public void deployToSlot(LogicalSlot slot) throws JobException {
        if (!this.currentExecution.tryAssignResource(slot)) {
            throw new IllegalStateException("Could not assign resource " + slot + " to current execution " + this.currentExecution + '.');
        }
        this.currentExecution.deploy();
    }

    public CompletableFuture<?> cancel() {
        Execution exec = this.currentExecution;
        exec.cancel();
        return exec.getReleaseFuture();
    }

    public CompletableFuture<?> suspend() {
        return this.currentExecution.suspend();
    }

    public void fail(Throwable t) {
        this.currentExecution.fail(t);
    }

    public void markFailed(Throwable t) {
        this.currentExecution.markFailed(t);
    }

    void scheduleOrUpdateConsumers(ResultPartitionID partitionId) {
        Execution execution = this.currentExecution;
        if (!partitionId.getProducerId().equals(execution.getAttemptId())) {
            return;
        }
        IntermediateResultPartition partition = this.resultPartitions.get(partitionId.getPartitionId());
        if (partition == null) {
            throw new IllegalStateException("Unknown partition " + partitionId + ".");
        }
        partition.markDataProduced();
        if (!partition.getIntermediateResult().getResultType().isPipelined()) {
            throw new IllegalArgumentException("ScheduleOrUpdateConsumers msg is only valid forpipelined partitions.");
        }
        execution.scheduleOrUpdateConsumers(partition.getConsumers());
    }

    void cachePartitionInfo(PartitionInfo partitionInfo) {
        this.getCurrentExecutionAttempt().cachePartitionInfo(partitionInfo);
    }

    List<IntermediateResultPartition> finishAllBlockingPartitions() {
        LinkedList<IntermediateResultPartition> finishedBlockingPartitions = null;
        for (IntermediateResultPartition partition : this.resultPartitions.values()) {
            if (!partition.getResultType().isBlocking() || !partition.markFinished()) continue;
            if (finishedBlockingPartitions == null) {
                finishedBlockingPartitions = new LinkedList<IntermediateResultPartition>();
            }
            finishedBlockingPartitions.add(partition);
        }
        if (finishedBlockingPartitions == null) {
            return Collections.emptyList();
        }
        return finishedBlockingPartitions;
    }

    boolean checkInputDependencyConstraints() {
        if (this.inputEdges.length == 0) {
            return true;
        }
        InputDependencyConstraint inputDependencyConstraint = this.getInputDependencyConstraint();
        switch (inputDependencyConstraint) {
            case ANY: {
                return this.isAnyInputConsumable();
            }
            case ALL: {
                return this.areAllInputsConsumable();
            }
        }
        throw new IllegalStateException("Unknown InputDependencyConstraint " + inputDependencyConstraint);
    }

    private boolean isAnyInputConsumable() {
        for (int inputNumber = 0; inputNumber < this.inputEdges.length; ++inputNumber) {
            if (!this.isInputConsumable(inputNumber)) continue;
            return true;
        }
        return false;
    }

    private boolean areAllInputsConsumable() {
        for (int inputNumber = 0; inputNumber < this.inputEdges.length; ++inputNumber) {
            if (this.isInputConsumable(inputNumber)) continue;
            return false;
        }
        return true;
    }

    boolean isInputConsumable(int inputNumber) {
        for (ExecutionEdge executionEdge : this.inputEdges[inputNumber]) {
            if (!executionEdge.getSource().isConsumable()) continue;
            return true;
        }
        return false;
    }

    void executionFinished(Execution execution) {
        this.getExecutionGraph().vertexFinished();
    }

    void notifyPendingDeployment(Execution execution) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraph().getExecutionDeploymentListener().onStartedDeployment(execution.getAttemptId(), execution.getAssignedResourceLocation().getResourceID());
        }
    }

    void notifyCompletedDeployment(Execution execution) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraph().getExecutionDeploymentListener().onCompletedDeployment(execution.getAttemptId());
        }
    }

    void notifyStateTransition(Execution execution, ExecutionState newState, Throwable error) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraph().notifyExecutionChange(execution, newState, error);
        }
    }

    private boolean isCurrentExecution(Execution execution) {
        return this.currentExecution == execution;
    }

    public String toString() {
        return this.getTaskNameWithSubtaskIndex();
    }

    public ArchivedExecutionVertex archive() {
        return new ArchivedExecutionVertex(this);
    }

    public boolean isLegacyScheduling() {
        return this.getExecutionGraph().isLegacyScheduling();
    }
}

