/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

class AbstractImitatingJobManagerMetricGroup
extends AbstractMetricGroup<AbstractMetricGroup<?>> {
    protected final String hostname;

    AbstractImitatingJobManagerMetricGroup(MetricRegistry registry, String hostname) {
        super(registry, AbstractImitatingJobManagerMetricGroup.getScope(registry, hostname), null);
        this.hostname = hostname;
    }

    private static String[] getScope(MetricRegistry registry, String hostname) {
        return registry.getScopeFormats().getJobManagerFormat().formatScope(hostname);
    }

    @Override
    protected final String getGroupName(CharacterFilter filter) {
        return "jobmanager";
    }

    @Override
    protected final void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_HOST, this.hostname);
    }

    @Override
    protected final QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.JobManagerQueryScopeInfo();
    }
}

