/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ManagedMemoryUtils {

    private static final Logger LOG = LoggerFactory.getLogger(ManagedMemoryUtils.class);
    private static final int MANAGED_MEMORY_FRACTION_SCALE = 16;
    private static final String[] MANAGED_MEMORY_CONSUMER_VALID_NAMES = new String[]{"DATAPROC", "PYTHON"};

    public static double convertToFractionOfSlot(ManagedMemoryUseCase useCase, double fractionOfUseCase, Set<ManagedMemoryUseCase> allUseCases, Configuration config, Optional<Boolean> stateBackendFromApplicationUsesManagedMemory, ClassLoader classLoader) {
        boolean stateBackendUsesManagedMemory = StateBackendLoader.stateBackendFromApplicationOrConfigOrDefaultUseManagedMemory(config, stateBackendFromApplicationUsesManagedMemory, classLoader);
        if (useCase.equals((Object)ManagedMemoryUseCase.STATE_BACKEND) && !stateBackendUsesManagedMemory) {
            return 0.0;
        }
        Map<ManagedMemoryUseCase, Integer> allUseCaseWeights = ManagedMemoryUtils.getManagedMemoryUseCaseWeightsFromConfig(config);
        int totalWeights = allUseCases.stream().filter(uc -> !uc.equals((Object)ManagedMemoryUseCase.STATE_BACKEND) || stateBackendUsesManagedMemory).mapToInt(uc -> allUseCaseWeights.getOrDefault(uc, 0)).sum();
        int useCaseWeight = allUseCaseWeights.getOrDefault(useCase, 0);
        double useCaseFractionOfSlot = totalWeights > 0 ? ManagedMemoryUtils.getFractionRoundedDown(useCaseWeight, totalWeights) : 0.0;
        return fractionOfUseCase * useCaseFractionOfSlot;
    }

    @VisibleForTesting
    static Map<ManagedMemoryUseCase, Integer> getManagedMemoryUseCaseWeightsFromConfig(Configuration config) {
        Map consumerWeights = (Map)config.get(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_WEIGHTS);
        for (String consumer : MANAGED_MEMORY_CONSUMER_VALID_NAMES) {
            if (consumerWeights.containsKey(consumer)) continue;
            LOG.debug("Managed memory consumer weight for {} is not configured. Jobs containing this type of managed memory consumers may fail due to not being able to allocate managed memory.", (Object)consumer);
        }
        return consumerWeights.entrySet().stream().flatMap(entry -> {
            String consumer = (String)entry.getKey();
            int weight = Integer.parseInt((String)entry.getValue());
            if (weight < 0) {
                throw new IllegalConfigurationException(String.format("Managed memory weight should not be negative. Configured weight for %s is %d.", consumer, weight));
            }
            if (weight == 0) {
                LOG.debug("Managed memory consumer weight for {} is configured to 0. Jobs containing this type of managed memory consumers may fail due to not being able to allocate managed memory.", (Object)consumer);
            }
            switch (consumer) {
                case "DATAPROC": {
                    return Stream.of(Tuple2.of((Object)ManagedMemoryUseCase.BATCH_OP, (Object)weight), Tuple2.of((Object)ManagedMemoryUseCase.STATE_BACKEND, (Object)weight));
                }
                case "PYTHON": {
                    return Stream.of(Tuple2.of((Object)ManagedMemoryUseCase.PYTHON, (Object)weight));
                }
            }
            throw new IllegalConfigurationException("Unknown managed memory consumer: " + consumer);
        }).collect(Collectors.toMap(tuple2 -> (ManagedMemoryUseCase)tuple2.f0, tuple2 -> (Integer)tuple2.f1));
    }

    public static double getFractionRoundedDown(long dividend, long divisor) {
        return BigDecimal.valueOf(dividend).divide(BigDecimal.valueOf(divisor), 16, 1).doubleValue();
    }
}

