/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import akka.actor.ActorSystem;
import akka.remote.transport.netty.ConfigSSLEngineProvider;
import com.typesafe.config.Config;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\t92)^:u_6\u001c6\u000bT#oO&tW\r\u0015:pm&$WM\u001d\u0006\u0003\u0007\u0011\tA!Y6lC*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"aD\f\u000e\u0003AQ!!\u0005\n\u0002\u000b9,G\u000f^=\u000b\u0005M!\u0012!\u0003;sC:\u001c\bo\u001c:u\u0015\t)b#\u0001\u0004sK6|G/\u001a\u0006\u0002\u0007%\u0011\u0001\u0004\u0005\u0002\u0018\u0007>tg-[4T'2+enZ5oKB\u0013xN^5eKJD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0007gf\u001cH/Z7\u0011\u0005qyR\"A\u000f\u000b\u0005y1\u0012!B1di>\u0014\u0018B\u0001\u0011\u001e\u0005-\t5\r^8s'f\u001cH/Z7\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0001C\u0003\u001bC\u0001\u00071\u0004C\u0004)\u0001\t\u0007I\u0011B\u0015\u0002\u001dM,7-\u001e:jif\u001cuN\u001c4jOV\t!\u0006\u0005\u0002,e5\tAF\u0003\u0002.]\u000511m\u001c8gS\u001eT!a\f\u0019\u0002\u0011QL\b/Z:bM\u0016T\u0011!M\u0001\u0004G>l\u0017BA\u001a-\u0005\u0019\u0019uN\u001c4jO\"1Q\u0007\u0001Q\u0001\n)\nqb]3dkJLG/_\"p]\u001aLw\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00035\u00196\u000b\u0014+skN$8\u000b^8sKV\t\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005!A.\u00198h\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\rM#(/\u001b8h\u0011\u0019\u0011\u0005\u0001)A\u0005s\u0005q1k\u0015'UeV\u001cHo\u0015;pe\u0016\u0004\u0003b\u0002#\u0001\u0005\u0004%I\u0001O\u0001\u0016'NcEK];tiN#xN]3QCN\u001cxo\u001c:e\u0011\u00191\u0005\u0001)A\u0005s\u000512k\u0015'UeV\u001cHo\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007\u0005C\u0004I\u0001\t\u0007I\u0011B%\u0002'M\u001bFjQ3si\u001aKgnZ3saJLg\u000e^:\u0016\u0003)\u00032a\u0013(:\u001b\u0005a%BA'>\u0003\u0011)H/\u001b7\n\u0005=c%\u0001\u0002'jgRDa!\u0015\u0001!\u0002\u0013Q\u0015\u0001F*T\u0019\u000e+'\u000f\u001e$j]\u001e,'\u000f\u001d:j]R\u001c\b\u0005C\u0003T\u0001\u0011EC+A\u0007ueV\u001cH/T1oC\u001e,'o]\u000b\u0002+B\u0019a+W.\u000e\u0003]S\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u0013Q!\u0011:sCf\u0004\"\u0001X2\u000e\u0003uS!AX0\u0002\u0007M\u001cHN\u0003\u0002aC\u0006\u0019a.\u001a;\u000b\u0003\t\fQA[1wCbL!\u0001Z/\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:")
public class CustomSSLEngineProvider
extends ConfigSSLEngineProvider {
    private final Config securityConfig;
    private final String SSLTrustStore;
    private final String SSLTrustStorePassword;
    private final List<String> SSLCertFingerprints;

    private Config securityConfig() {
        return this.securityConfig;
    }

    private String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    private String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    private List<String> SSLCertFingerprints() {
        return this.SSLCertFingerprints;
    }

    @Override
    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = this.SSLCertFingerprints().isEmpty() ? TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()) : new FingerprintTrustManagerFactory(this.SSLCertFingerprints());
        trustManagerFactory.init(this.loadKeystore(this.SSLTrustStore(), this.SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public CustomSSLEngineProvider(ActorSystem system) {
        super(system);
        this.securityConfig = system.settings().config().getConfig("akka.remote.netty.ssl.security");
        this.SSLTrustStore = this.securityConfig().getString("trust-store");
        this.SSLTrustStorePassword = this.securityConfig().getString("trust-store-password");
        this.SSLCertFingerprints = this.securityConfig().getStringList("cert-fingerprints");
    }
}

