/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.InternalExecutionGraphAccessor;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.apache.flink.types.Either;
import org.apache.flink.util.SerializedValue;

public class TaskDeploymentDescriptorFactory {
    private final ExecutionAttemptID executionId;
    private final int attemptNumber;
    private final TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> serializedJobInformation;
    private final TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> taskInfo;
    private final JobID jobID;
    private final PartitionLocationConstraint partitionDeploymentConstraint;
    private final int subtaskIndex;
    private final List<List<IntermediateResultPartition>> consumedPartitions;

    private TaskDeploymentDescriptorFactory(ExecutionAttemptID executionId, int attemptNumber, TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> serializedJobInformation, TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> taskInfo, JobID jobID, PartitionLocationConstraint partitionDeploymentConstraint, int subtaskIndex, List<List<IntermediateResultPartition>> consumedPartitions) {
        this.executionId = executionId;
        this.attemptNumber = attemptNumber;
        this.serializedJobInformation = serializedJobInformation;
        this.taskInfo = taskInfo;
        this.jobID = jobID;
        this.partitionDeploymentConstraint = partitionDeploymentConstraint;
        this.subtaskIndex = subtaskIndex;
        this.consumedPartitions = consumedPartitions;
    }

    public TaskDeploymentDescriptor createDeploymentDescriptor(AllocationID allocationID, @Nullable JobManagerTaskRestore taskRestore, Collection<ResultPartitionDeploymentDescriptor> producedPartitions) {
        return new TaskDeploymentDescriptor(this.jobID, this.serializedJobInformation, this.taskInfo, this.executionId, allocationID, this.subtaskIndex, this.attemptNumber, taskRestore, new ArrayList<ResultPartitionDeploymentDescriptor>(producedPartitions), this.createInputGateDeploymentDescriptors());
    }

    private List<InputGateDeploymentDescriptor> createInputGateDeploymentDescriptors() {
        ArrayList<InputGateDeploymentDescriptor> inputGates = new ArrayList<InputGateDeploymentDescriptor>(this.consumedPartitions.size());
        for (List<IntermediateResultPartition> partitions : this.consumedPartitions) {
            IntermediateResultPartition resultPartition = partitions.get(0);
            int numConsumers = resultPartition.getConsumerVertexGroups().get(0).size();
            int queueToRequest = this.subtaskIndex % numConsumers;
            IntermediateResult consumedIntermediateResult = resultPartition.getIntermediateResult();
            IntermediateDataSetID resultId = consumedIntermediateResult.getId();
            ResultPartitionType partitionType = consumedIntermediateResult.getResultType();
            inputGates.add(new InputGateDeploymentDescriptor(resultId, partitionType, queueToRequest, this.getConsumedPartitionShuffleDescriptors(partitions)));
        }
        return inputGates;
    }

    private ShuffleDescriptor[] getConsumedPartitionShuffleDescriptors(List<IntermediateResultPartition> partitions) {
        ShuffleDescriptor[] shuffleDescriptors = new ShuffleDescriptor[partitions.size()];
        for (int i = 0; i < partitions.size(); ++i) {
            shuffleDescriptors[i] = TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor(partitions.get(i), this.partitionDeploymentConstraint);
        }
        return shuffleDescriptors;
    }

    public static TaskDeploymentDescriptorFactory fromExecutionVertex(ExecutionVertex executionVertex, int attemptNumber) throws IOException {
        InternalExecutionGraphAccessor internalExecutionGraphAccessor = executionVertex.getExecutionGraphAccessor();
        ArrayList<List<IntermediateResultPartition>> consumedPartitions = new ArrayList<List<IntermediateResultPartition>>();
        for (ConsumedPartitionGroup partitionGroup : executionVertex.getAllConsumedPartitionGroups()) {
            ArrayList<IntermediateResultPartition> partitions = new ArrayList<IntermediateResultPartition>();
            for (IntermediateResultPartitionID partitionId : partitionGroup) {
                partitions.add(internalExecutionGraphAccessor.getResultPartitionOrThrow(partitionId));
            }
            consumedPartitions.add(partitions);
        }
        return new TaskDeploymentDescriptorFactory(executionVertex.getCurrentExecutionAttempt().getAttemptId(), attemptNumber, TaskDeploymentDescriptorFactory.getSerializedJobInformation(internalExecutionGraphAccessor), TaskDeploymentDescriptorFactory.getSerializedTaskInformation(executionVertex.getJobVertex().getTaskInformationOrBlobKey()), internalExecutionGraphAccessor.getJobID(), internalExecutionGraphAccessor.getPartitionLocationConstraint(), executionVertex.getParallelSubtaskIndex(), consumedPartitions);
    }

    private static TaskDeploymentDescriptor.MaybeOffloaded<JobInformation> getSerializedJobInformation(InternalExecutionGraphAccessor internalExecutionGraphAccessor) {
        Either<SerializedValue<JobInformation>, PermanentBlobKey> jobInformationOrBlobKey = internalExecutionGraphAccessor.getJobInformationOrBlobKey();
        if (jobInformationOrBlobKey.isLeft()) {
            return new TaskDeploymentDescriptor.NonOffloaded<JobInformation>((SerializedValue)jobInformationOrBlobKey.left());
        }
        return new TaskDeploymentDescriptor.Offloaded<JobInformation>((PermanentBlobKey)jobInformationOrBlobKey.right());
    }

    private static TaskDeploymentDescriptor.MaybeOffloaded<TaskInformation> getSerializedTaskInformation(Either<SerializedValue<TaskInformation>, PermanentBlobKey> taskInfo) {
        return taskInfo.isLeft() ? new TaskDeploymentDescriptor.NonOffloaded((SerializedValue)taskInfo.left()) : new TaskDeploymentDescriptor.Offloaded((PermanentBlobKey)taskInfo.right());
    }

    public static ShuffleDescriptor getConsumedPartitionShuffleDescriptor(IntermediateResultPartition consumedPartition, PartitionLocationConstraint partitionDeploymentConstraint) {
        Execution producer = consumedPartition.getProducer().getCurrentExecutionAttempt();
        ExecutionState producerState = producer.getState();
        Optional<ResultPartitionDeploymentDescriptor> consumedPartitionDescriptor = producer.getResultPartitionDeploymentDescriptor(consumedPartition.getPartitionId());
        ResultPartitionID consumedPartitionId = new ResultPartitionID(consumedPartition.getPartitionId(), producer.getAttemptId());
        return TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor(consumedPartitionId, consumedPartition.getResultType(), consumedPartition.isConsumable(), producerState, partitionDeploymentConstraint, consumedPartitionDescriptor.orElse(null));
    }

    @VisibleForTesting
    static ShuffleDescriptor getConsumedPartitionShuffleDescriptor(ResultPartitionID consumedPartitionId, ResultPartitionType resultPartitionType, boolean isConsumable, ExecutionState producerState, PartitionLocationConstraint partitionDeploymentConstraint, @Nullable ResultPartitionDeploymentDescriptor consumedPartitionDescriptor) {
        if ((resultPartitionType.isPipelined() || isConsumable) && consumedPartitionDescriptor != null && TaskDeploymentDescriptorFactory.isProducerAvailable(producerState)) {
            return consumedPartitionDescriptor.getShuffleDescriptor();
        }
        if (partitionDeploymentConstraint == PartitionLocationConstraint.CAN_BE_UNKNOWN) {
            return new UnknownShuffleDescriptor(consumedPartitionId);
        }
        throw TaskDeploymentDescriptorFactory.handleConsumedPartitionShuffleDescriptorErrors(consumedPartitionId, resultPartitionType, isConsumable, producerState);
    }

    private static RuntimeException handleConsumedPartitionShuffleDescriptorErrors(ResultPartitionID consumedPartitionId, ResultPartitionType resultPartitionType, boolean isConsumable, ExecutionState producerState) {
        String msg = TaskDeploymentDescriptorFactory.isProducerFailedOrCanceled(producerState) ? "Trying to consume an input partition whose producer has been canceled or failed. The producer is in state " + (Object)((Object)producerState) + "." : String.format("Trying to consume an input partition whose producer is not ready (result type: %s, partition consumable: %s, producer state: %s, partition id: %s).", new Object[]{resultPartitionType, isConsumable, producerState, consumedPartitionId});
        return new IllegalStateException(msg);
    }

    private static boolean isProducerAvailable(ExecutionState producerState) {
        return producerState == ExecutionState.RUNNING || producerState == ExecutionState.INITIALIZING || producerState == ExecutionState.FINISHED || producerState == ExecutionState.SCHEDULED || producerState == ExecutionState.DEPLOYING;
    }

    private static boolean isProducerFailedOrCanceled(ExecutionState producerState) {
        return producerState == ExecutionState.CANCELING || producerState == ExecutionState.CANCELED || producerState == ExecutionState.FAILED;
    }

    public static enum PartitionLocationConstraint {
        MUST_BE_KNOWN,
        CAN_BE_UNKNOWN;


        public static PartitionLocationConstraint fromJobType(JobType jobType) {
            switch (jobType) {
                case BATCH: {
                    return CAN_BE_UNKNOWN;
                }
                case STREAMING: {
                    return MUST_BE_KNOWN;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown JobType %s. Cannot derive partition location constraint for it.", new Object[]{jobType}));
        }
    }
}

