/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class EdgeManager {
    private final Map<IntermediateResultPartitionID, List<ConsumerVertexGroup>> partitionConsumers = new HashMap<IntermediateResultPartitionID, List<ConsumerVertexGroup>>();
    private final Map<ExecutionVertexID, List<ConsumedPartitionGroup>> vertexConsumedPartitions = new HashMap<ExecutionVertexID, List<ConsumedPartitionGroup>>();

    public void connectPartitionWithConsumerVertexGroup(IntermediateResultPartitionID resultPartitionId, ConsumerVertexGroup consumerVertexGroup) {
        Preconditions.checkNotNull((Object)consumerVertexGroup);
        List<ConsumerVertexGroup> consumers = this.getConsumerVertexGroupsForPartitionInternal(resultPartitionId);
        Preconditions.checkState((boolean)consumers.isEmpty(), (Object)"Currently there has to be exactly one consumer in real jobs");
        consumers.add(consumerVertexGroup);
    }

    public void connectVertexWithConsumedPartitionGroup(ExecutionVertexID executionVertexId, ConsumedPartitionGroup consumedPartitionGroup) {
        Preconditions.checkNotNull((Object)consumedPartitionGroup);
        List<ConsumedPartitionGroup> consumedPartitions = this.getConsumedPartitionGroupsForVertexInternal(executionVertexId);
        consumedPartitions.add(consumedPartitionGroup);
    }

    private List<ConsumerVertexGroup> getConsumerVertexGroupsForPartitionInternal(IntermediateResultPartitionID resultPartitionId) {
        return this.partitionConsumers.computeIfAbsent(resultPartitionId, id -> new ArrayList());
    }

    private List<ConsumedPartitionGroup> getConsumedPartitionGroupsForVertexInternal(ExecutionVertexID executionVertexId) {
        return this.vertexConsumedPartitions.computeIfAbsent(executionVertexId, id -> new ArrayList());
    }

    public List<ConsumerVertexGroup> getConsumerVertexGroupsForPartition(IntermediateResultPartitionID resultPartitionId) {
        return Collections.unmodifiableList(this.getConsumerVertexGroupsForPartitionInternal(resultPartitionId));
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroupsForVertex(ExecutionVertexID executionVertexId) {
        return Collections.unmodifiableList(this.getConsumedPartitionGroupsForVertexInternal(executionVertexId));
    }
}

