/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.utils.ZKPaths;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.Preconditions;

public class ZooKeeperHaServices
extends AbstractHaServices {
    private static final String RESOURCE_MANAGER_LEADER_PATH = "/resource_manager_lock";
    private static final String DISPATCHER_LEADER_PATH = "/dispatcher_lock";
    private static final String JOB_MANAGER_LEADER_PATH = "/job_manager_lock";
    private static final String REST_SERVER_LEADER_PATH = "/rest_server_lock";
    private final CuratorFramework client;

    public ZooKeeperHaServices(CuratorFramework client, Executor executor, Configuration configuration, BlobStoreService blobStoreService) {
        super(configuration, executor, blobStoreService);
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client);
    }

    @Override
    public CheckpointRecoveryFactory createCheckpointRecoveryFactory() {
        return new ZooKeeperCheckpointRecoveryFactory(this.client, this.configuration, this.ioExecutor);
    }

    @Override
    public JobGraphStore createJobGraphStore() throws Exception {
        return ZooKeeperUtils.createJobGraphs(this.client, this.configuration);
    }

    @Override
    public RunningJobsRegistry createRunningJobsRegistry() {
        return new ZooKeeperRunningJobsRegistry(this.client, this.configuration);
    }

    @Override
    protected LeaderElectionService createLeaderElectionService(String leaderName) {
        return ZooKeeperUtils.createLeaderElectionService(this.client, this.configuration, leaderName);
    }

    @Override
    protected LeaderRetrievalService createLeaderRetrievalService(String leaderName) {
        return ZooKeeperUtils.createLeaderRetrievalService(this.client, this.configuration, leaderName);
    }

    @Override
    public void internalClose() {
        this.client.close();
    }

    @Override
    public void internalCleanup() throws Exception {
        this.cleanupZooKeeperPaths();
    }

    @Override
    public void internalCleanupJobData(JobID jobID) throws Exception {
        List paths = Stream.of(HighAvailabilityOptions.HA_ZOOKEEPER_CHECKPOINTS_PATH, HighAvailabilityOptions.HA_ZOOKEEPER_CHECKPOINT_COUNTER_PATH, HighAvailabilityOptions.HA_ZOOKEEPER_LATCH_PATH, HighAvailabilityOptions.HA_ZOOKEEPER_LEADER_PATH).map(arg_0 -> ((Configuration)this.configuration).getString(arg_0)).map(parent -> parent + "/" + jobID).collect(Collectors.toList());
        for (String path : paths) {
            this.deleteZNode(path);
        }
    }

    @Override
    protected String getLeaderNameForResourceManager() {
        return RESOURCE_MANAGER_LEADER_PATH;
    }

    @Override
    protected String getLeaderNameForDispatcher() {
        return DISPATCHER_LEADER_PATH;
    }

    @Override
    public String getLeaderNameForJobManager(JobID jobID) {
        return "/" + jobID + JOB_MANAGER_LEADER_PATH;
    }

    @Override
    protected String getLeaderNameForRestServer() {
        return REST_SERVER_LEADER_PATH;
    }

    private void cleanupZooKeeperPaths() throws Exception {
        this.deleteOwnedZNode();
        this.tryDeleteEmptyParentZNodes();
    }

    private void deleteOwnedZNode() throws Exception {
        this.deleteZNode("/");
    }

    private void deleteZNode(String path) throws Exception {
        boolean zNodeDeleted = false;
        while (!zNodeDeleted) {
            Stat stat = (Stat)this.client.checkExists().forPath(path);
            if (stat == null) {
                this.logger.debug("znode {} has been deleted", (Object)path);
                return;
            }
            try {
                this.client.delete().deletingChildrenIfNeeded().forPath(path);
                zNodeDeleted = true;
            }
            catch (KeeperException.NoNodeException ignored) {
                this.logger.debug("Retrying to delete znode because of other concurrent delete operation.");
            }
        }
    }

    private void tryDeleteEmptyParentZNodes() throws Exception {
        String remainingPath = ZooKeeperHaServices.getParentPath(ZooKeeperHaServices.getNormalizedPath(this.client.getNamespace()));
        CuratorFramework nonNamespaceClient = this.client.usingNamespace(null);
        while (!ZooKeeperHaServices.isRootPath(remainingPath)) {
            try {
                nonNamespaceClient.delete().forPath(remainingPath);
            }
            catch (KeeperException.NotEmptyException ignored) {
                break;
            }
            remainingPath = ZooKeeperHaServices.getParentPath(remainingPath);
        }
    }

    private static boolean isRootPath(String remainingPath) {
        return "/".equals(remainingPath);
    }

    @Nonnull
    private static String getNormalizedPath(String path) {
        return ZKPaths.makePath((String)path, (String)"");
    }

    @Nonnull
    private static String getParentPath(String path) {
        return ZKPaths.getPathAndNode((String)path).getPath();
    }
}

