/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.stats.Statistics;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexThreadInfoStats;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexThreadInfoTracker;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoRequestCoordinator;

public class JobVertexThreadInfoTrackerBuilder<T extends Statistics> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;
    private final Function<JobVertexThreadInfoStats, T> createStatsFn;
    private final ScheduledExecutorService executor;
    private final Time restTimeout;
    private ThreadInfoRequestCoordinator coordinator;
    private Duration cleanUpInterval;
    private int numSamples;
    private Duration statsRefreshInterval;
    private Duration delayBetweenSamples;
    private int maxThreadInfoDepth;

    JobVertexThreadInfoTrackerBuilder(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, Function<JobVertexThreadInfoStats, T> createStatsFn, ScheduledExecutorService executor, Time restTimeout) {
        this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
        this.createStatsFn = createStatsFn;
        this.executor = executor;
        this.restTimeout = restTimeout;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setCoordinator(ThreadInfoRequestCoordinator coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setCleanUpInterval(Duration cleanUpInterval) {
        this.cleanUpInterval = cleanUpInterval;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setNumSamples(int numSamples) {
        this.numSamples = numSamples;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setStatsRefreshInterval(Duration statsRefreshInterval) {
        this.statsRefreshInterval = statsRefreshInterval;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setDelayBetweenSamples(Duration delayBetweenSamples) {
        this.delayBetweenSamples = delayBetweenSamples;
        return this;
    }

    public JobVertexThreadInfoTrackerBuilder<T> setMaxThreadInfoDepth(int maxThreadInfoDepth) {
        this.maxThreadInfoDepth = maxThreadInfoDepth;
        return this;
    }

    public JobVertexThreadInfoTracker<T> build() {
        return new JobVertexThreadInfoTracker<T>(this.coordinator, this.resourceManagerGatewayRetriever, this.createStatsFn, this.executor, this.cleanUpInterval, this.numSamples, this.statsRefreshInterval, this.delayBetweenSamples, this.maxThreadInfoDepth, this.restTimeout);
    }

    public static <T extends Statistics> JobVertexThreadInfoTrackerBuilder<T> newBuilder(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, Function<JobVertexThreadInfoStats, T> createStatsFn, ScheduledExecutorService executor, Time restTimeout) {
        return new JobVertexThreadInfoTrackerBuilder<T>(resourceManagerGatewayRetriever, createStatsFn, executor, restTimeout);
    }
}

