/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.IOError;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.CliUtils;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public abstract class CliView<OP extends Enum<OP>, OUT> {
    protected final CliClient client;
    protected int offsetX;
    protected int offsetY;
    private volatile boolean isRunning;
    private Thread inputThread;
    private int width;
    private int height;
    private final BindingReader keyReader;
    private AttributedString titleLine;
    private List<AttributedString> headerLines;
    private List<AttributedString> mainHeaderLines;
    private List<AttributedString> mainLines;
    private List<AttributedString> footerLines;
    private int totalMainWidth;
    private SqlExecutionException executionException;
    private OUT result;

    public CliView(CliClient client) {
        this.client = client;
        this.keyReader = new BindingReader(client.getTerminal().reader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        this.isRunning = true;
        this.inputThread = Thread.currentThread();
        Tuple2<Attributes, Map<Terminal.Signal, Terminal.SignalHandler>> prev = this.prepareTerminal();
        this.ensureTerminalFullScreen();
        this.updateSize();
        this.init();
        CliView cliView = this;
        synchronized (cliView) {
            this.display();
        }
        KeyMap<OP> keys = this.getKeys();
        while (this.isRunning) {
            Enum operation;
            try {
                operation = (Enum)this.keyReader.readBinding(keys, null, true);
            }
            catch (IOError e) {
                break;
            }
            if (operation == null) continue;
            CliView cliView2 = this;
            synchronized (cliView2) {
                try {
                    this.evaluate(operation, this.keyReader.getLastBinding());
                }
                catch (SqlExecutionException e) {
                    this.close(e);
                }
                if (this.isRunning) {
                    this.ensureTerminalFullScreen();
                    this.display();
                }
            }
        }
        this.cleanUp();
        this.restoreTerminal(prev);
        this.unsetTerminalFullScreen();
        if (this.executionException != null) {
            throw this.executionException;
        }
    }

    public OUT getResult() {
        return this.result;
    }

    protected boolean isRunning() {
        return this.isRunning;
    }

    protected void close() {
        if (this.isRunning) {
            this.isRunning = false;
            if (Thread.currentThread() != this.inputThread) {
                this.inputThread.interrupt();
            }
        }
    }

    protected void close(SqlExecutionException e) {
        this.executionException = e;
        this.close();
    }

    protected void close(OUT result) {
        this.result = result;
        this.isRunning = false;
    }

    protected void display() {
        List<AttributedString> headerLines = this.getHeaderLines();
        List<AttributedString> mainHeaderLines = this.getMainHeaderLines();
        List<AttributedString> mainLines = this.getMainLines();
        List<AttributedString> footerLines = this.getFooterLines();
        int visibleMainHeight = this.getVisibleMainHeight();
        int totalMainWidth = this.getTotalMainWidth();
        this.client.clearTerminal();
        ArrayList lines = new ArrayList();
        this.client.getTerminal().writer().println(this.computeTitleLine().toAnsi());
        headerLines.forEach(l -> this.client.getTerminal().writer().println(l.toAnsi()));
        this.offsetY = visibleMainHeight > mainLines.size() ? 0 : Math.min(mainLines.size() - visibleMainHeight, this.offsetY);
        this.offsetX = this.width > totalMainWidth ? 0 : Math.min(totalMainWidth - this.width, this.offsetX);
        List<AttributedString> windowedMainLines = mainLines.subList(this.offsetY, Math.min(mainLines.size(), this.offsetY + visibleMainHeight));
        Stream.concat(mainHeaderLines.stream(), windowedMainLines.stream()).forEach(l -> {
            if (this.offsetX < l.length()) {
                AttributedString windowX = l.substring(this.offsetX, Math.min(l.length(), this.offsetX + this.width));
                this.client.getTerminal().writer().println(windowX.toAnsi());
            } else {
                this.client.getTerminal().writer().println();
            }
        });
        int emptyHeight = this.height - 1 - headerLines.size() - windowedMainLines.size() - mainHeaderLines.size() - footerLines.size();
        IntStream.range(0, emptyHeight).forEach(i -> this.client.getTerminal().writer().println());
        IntStream.range(0, footerLines.size()).forEach(i -> {
            AttributedString l = (AttributedString)footerLines.get(i);
            if (i == footerLines.size() - 1) {
                this.client.getTerminal().writer().print(l.toAnsi());
            } else {
                this.client.getTerminal().writer().println(l.toAnsi());
            }
        });
        this.client.getTerminal().flush();
    }

    protected void scrollLeft() {
        if (this.offsetX > 0) {
            --this.offsetX;
        }
    }

    protected void scrollRight() {
        int maxOffset = Math.max(0, this.getTotalMainWidth() - this.width);
        if (this.offsetX < maxOffset) {
            ++this.offsetX;
        }
    }

    protected void scrollUp() {
        if (this.offsetY > 0) {
            --this.offsetY;
        }
    }

    protected void scrollDown() {
        this.scrollDown(1);
    }

    protected void scrollDown(int n) {
        int maxOffset = Math.max(0, this.getMainLines().size() - this.getVisibleMainHeight());
        this.offsetY = Math.min(maxOffset, this.offsetY + n);
    }

    protected int getVisibleMainHeight() {
        return this.height - 1 - this.getHeaderLines().size() - this.getMainHeaderLines().size() - this.getFooterLines().size();
    }

    protected List<AttributedString> getHeaderLines() {
        if (this.headerLines == null) {
            this.headerLines = this.computeHeaderLines();
        }
        return this.headerLines;
    }

    protected List<AttributedString> getMainHeaderLines() {
        if (this.mainHeaderLines == null) {
            this.mainHeaderLines = this.computeMainHeaderLines();
            this.totalMainWidth = this.computeTotalMainWidth();
        }
        return this.mainHeaderLines;
    }

    protected List<AttributedString> getMainLines() {
        if (this.mainLines == null) {
            this.mainLines = this.computeMainLines();
            this.totalMainWidth = this.computeTotalMainWidth();
        }
        return this.mainLines;
    }

    protected List<AttributedString> getFooterLines() {
        if (this.footerLines == null) {
            this.footerLines = this.computeFooterLines();
        }
        return this.footerLines;
    }

    protected int getTotalMainWidth() {
        if (this.totalMainWidth <= 0) {
            this.totalMainWidth = this.computeTotalMainWidth();
        }
        return this.totalMainWidth;
    }

    protected AttributedString getTitleLine() {
        if (this.titleLine == null) {
            this.titleLine = this.computeTitleLine();
        }
        return this.titleLine;
    }

    protected void resetAllParts() {
        this.titleLine = null;
        this.headerLines = null;
        this.mainHeaderLines = null;
        this.mainLines = null;
        this.footerLines = null;
        this.totalMainWidth = 0;
    }

    protected void resetMainPart() {
        this.mainHeaderLines = null;
        this.mainLines = null;
        this.totalMainWidth = 0;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    private void updateSize() {
        this.width = this.client.getWidth();
        this.height = this.client.getHeight();
        this.totalMainWidth = this.width;
        this.resetAllParts();
    }

    private void ensureTerminalFullScreen() {
        Terminal terminal = this.client.getTerminal();
        terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
    }

    private Tuple2<Attributes, Map<Terminal.Signal, Terminal.SignalHandler>> prepareTerminal() {
        Terminal terminal = this.client.getTerminal();
        Attributes prevAttributes = terminal.getAttributes();
        Attributes newAttr = new Attributes(prevAttributes);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 1);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 0);
        newAttr.setControlChar(Attributes.ControlChar.VINTR, 0);
        terminal.setAttributes(newAttr);
        HashMap<Terminal.Signal, Terminal.SignalHandler> prevSignals = new HashMap<Terminal.Signal, Terminal.SignalHandler>();
        prevSignals.put(Terminal.Signal.WINCH, terminal.handle(Terminal.Signal.WINCH, this::handleSignal));
        prevSignals.put(Terminal.Signal.INT, terminal.handle(Terminal.Signal.INT, this::handleSignal));
        prevSignals.put(Terminal.Signal.QUIT, terminal.handle(Terminal.Signal.QUIT, this::handleSignal));
        return Tuple2.of((Object)prevAttributes, prevSignals);
    }

    private void restoreTerminal(Tuple2<Attributes, Map<Terminal.Signal, Terminal.SignalHandler>> prev) {
        Terminal terminal = this.client.getTerminal();
        terminal.setAttributes((Attributes)prev.f0);
        ((Map)prev.f1).forEach(terminal::handle);
    }

    private void unsetTerminalFullScreen() {
        Terminal terminal = this.client.getTerminal();
        terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
        terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
        terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
    }

    private int computeTotalMainWidth() {
        List<AttributedString> mainLines = this.getMainLines();
        List<AttributedString> mainHeaderLines = this.getMainHeaderLines();
        int max1 = mainLines.stream().mapToInt(AttributedString::length).max().orElse(0);
        int max2 = mainHeaderLines.stream().mapToInt(AttributedString::length).max().orElse(0);
        return Math.max(max1, max2);
    }

    private AttributedString computeTitleLine() {
        String title = this.getTitle();
        AttributedStringBuilder titleLine = new AttributedStringBuilder();
        titleLine.style(AttributedStyle.INVERSE);
        int totalMargin = this.width - title.length();
        int margin = totalMargin / 2;
        CliUtils.repeatChar(titleLine, ' ', margin);
        titleLine.append(title);
        CliUtils.repeatChar(titleLine, ' ', margin + totalMargin % 2);
        return titleLine.toAttributedString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSignal(Terminal.Signal signal) {
        CliView cliView = this;
        synchronized (cliView) {
            switch (signal) {
                case INT: {
                    this.close(new SqlExecutionException("Forced interrupt."));
                    break;
                }
                case QUIT: {
                    this.close(new SqlExecutionException("Forced cancellation."));
                    break;
                }
                case WINCH: {
                    this.updateSize();
                    if (!this.isRunning) break;
                    this.display();
                }
            }
        }
    }

    protected abstract void init();

    protected abstract KeyMap<OP> getKeys();

    protected abstract void evaluate(OP var1, String var2);

    protected abstract String getTitle();

    protected abstract List<AttributedString> computeHeaderLines();

    protected abstract List<AttributedString> computeMainHeaderLines();

    protected abstract List<AttributedString> computeMainLines();

    protected abstract List<AttributedString> computeFooterLines();

    protected abstract void cleanUp();
}

