/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config.entries;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.entries.ConfigEntry;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ExecutionEntry
extends ConfigEntry {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionEntry.class);
    public static final ExecutionEntry DEFAULT_INSTANCE = new ExecutionEntry(new DescriptorProperties(true));
    public static final String EXECUTION_PLANNER = "planner";
    public static final String EXECUTION_PLANNER_VALUE_OLD = "old";
    public static final String EXECUTION_PLANNER_VALUE_BLINK = "blink";
    public static final String EXECUTION_TYPE = "type";
    public static final String EXECUTION_TYPE_VALUE_STREAMING = "streaming";
    private static final String EXECUTION_TYPE_VALUE_BATCH = "batch";
    public static final String EXECUTION_TIME_CHARACTERISTIC = "time-characteristic";
    private static final String EXECUTION_TIME_CHARACTERISTIC_VALUE_EVENT_TIME = "event-time";
    private static final String EXECUTION_TIME_CHARACTERISTIC_VALUE_PROCESSING_TIME = "processing-time";
    public static final String EXECUTION_PERIODIC_WATERMARKS_INTERVAL = "periodic-watermarks-interval";
    public static final String EXECUTION_MIN_STATE_RETENTION = "min-idle-state-retention";
    public static final String EXECUTION_MAX_STATE_RETENTION = "max-idle-state-retention";
    public static final String EXECUTION_PARALLELISM = "parallelism";
    public static final String EXECUTION_MAX_PARALLELISM = "max-parallelism";
    public static final String EXECUTION_RESULT_MODE = "result-mode";
    public static final String EXECUTION_MAX_TABLE_RESULT_ROWS = "max-table-result-rows";
    public static final String EXECUTION_RESTART_STRATEGY_TYPE = "restart-strategy.type";
    private static final String EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FALLBACK = "fallback";
    private static final String EXECUTION_RESTART_STRATEGY_TYPE_VALUE_NONE = "none";
    private static final String EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FIXED_DELAY = "fixed-delay";
    private static final String EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FAILURE_RATE = "failure-rate";
    public static final String EXECUTION_RESTART_STRATEGY_ATTEMPTS = "restart-strategy.attempts";
    public static final String EXECUTION_RESTART_STRATEGY_DELAY = "restart-strategy.delay";
    public static final String EXECUTION_RESTART_STRATEGY_FAILURE_RATE_INTERVAL = "restart-strategy.failure-rate-interval";
    public static final String EXECUTION_RESTART_STRATEGY_MAX_FAILURES_PER_INTERVAL = "restart-strategy.max-failures-per-interval";
    public static final String EXECUTION_CURRENT_CATALOG = "current-catalog";
    public static final String EXECUTION_CURRENT_DATABASE = "current-database";

    private ExecutionEntry(DescriptorProperties properties) {
        super(properties);
    }

    @Override
    protected void validate(DescriptorProperties properties) {
        properties.validateEnumValues(EXECUTION_PLANNER, true, Arrays.asList(EXECUTION_PLANNER_VALUE_OLD, EXECUTION_PLANNER_VALUE_BLINK));
        properties.validateEnumValues(EXECUTION_TYPE, true, Arrays.asList(EXECUTION_TYPE_VALUE_BATCH, EXECUTION_TYPE_VALUE_STREAMING));
        properties.validateEnumValues(EXECUTION_TIME_CHARACTERISTIC, true, Arrays.asList(EXECUTION_TIME_CHARACTERISTIC_VALUE_EVENT_TIME, EXECUTION_TIME_CHARACTERISTIC_VALUE_PROCESSING_TIME));
        properties.validateLong(EXECUTION_PERIODIC_WATERMARKS_INTERVAL, true, 1L);
        properties.validateLong(EXECUTION_MIN_STATE_RETENTION, true, 0L);
        properties.validateLong(EXECUTION_MAX_STATE_RETENTION, true, 0L);
        properties.validateInt(EXECUTION_PARALLELISM, true, 1);
        properties.validateInt(EXECUTION_MAX_PARALLELISM, true, 1);
        properties.validateInt(EXECUTION_MAX_TABLE_RESULT_ROWS, true, 1);
        properties.validateEnumValues(EXECUTION_RESTART_STRATEGY_TYPE, true, Arrays.asList(EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FALLBACK, EXECUTION_RESTART_STRATEGY_TYPE_VALUE_NONE, EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FIXED_DELAY, EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FAILURE_RATE));
        properties.validateInt(EXECUTION_RESTART_STRATEGY_ATTEMPTS, true, 1);
        properties.validateLong(EXECUTION_RESTART_STRATEGY_DELAY, true, 0L);
        properties.validateLong(EXECUTION_RESTART_STRATEGY_FAILURE_RATE_INTERVAL, true, 1L);
        properties.validateInt(EXECUTION_RESTART_STRATEGY_MAX_FAILURES_PER_INTERVAL, true, 1);
        properties.validateString(EXECUTION_CURRENT_CATALOG, true, 1);
        properties.validateString(EXECUTION_CURRENT_DATABASE, true, 1);
    }

    public boolean inStreamingMode() {
        return this.properties.getOptionalString(EXECUTION_TYPE).map(v -> v.equals(EXECUTION_TYPE_VALUE_STREAMING)).orElse(true);
    }

    public boolean inBatchMode() {
        return this.properties.getOptionalString(EXECUTION_TYPE).map(v -> v.equals(EXECUTION_TYPE_VALUE_BATCH)).orElse(false);
    }

    public boolean isStreamingPlanner() {
        String planner = this.properties.getOptionalString(EXECUTION_PLANNER).orElse(EXECUTION_PLANNER_VALUE_BLINK);
        if (planner.equals(EXECUTION_PLANNER_VALUE_BLINK)) {
            return true;
        }
        if (planner.equals(EXECUTION_PLANNER_VALUE_OLD)) {
            return this.inStreamingMode();
        }
        return false;
    }

    public boolean isBlinkPlanner() {
        String planner = this.properties.getOptionalString(EXECUTION_PLANNER).orElse(EXECUTION_PLANNER_VALUE_BLINK);
        return !planner.equals(EXECUTION_PLANNER_VALUE_OLD);
    }

    public Optional<Integer> getParallelism() {
        return this.properties.getOptionalInt(EXECUTION_PARALLELISM);
    }

    public int getMaxParallelism() {
        return this.properties.getOptionalInt(EXECUTION_MAX_PARALLELISM).orElseGet(() -> this.useDefaultValue(EXECUTION_MAX_PARALLELISM, 128));
    }

    public RestartStrategies.RestartStrategyConfiguration getRestartStrategy() {
        return this.properties.getOptionalString(EXECUTION_RESTART_STRATEGY_TYPE).flatMap(v -> {
            switch (v) {
                case "none": {
                    return Optional.of(RestartStrategies.noRestart());
                }
                case "fixed-delay": {
                    int attempts = this.properties.getOptionalInt(EXECUTION_RESTART_STRATEGY_ATTEMPTS).orElseGet(() -> this.useDefaultValue(EXECUTION_RESTART_STRATEGY_ATTEMPTS, Integer.MAX_VALUE));
                    long fixedDelay = this.properties.getOptionalLong(EXECUTION_RESTART_STRATEGY_DELAY).orElseGet(() -> this.useDefaultValue(EXECUTION_RESTART_STRATEGY_DELAY, 10000L));
                    return Optional.of(RestartStrategies.fixedDelayRestart((int)attempts, (long)fixedDelay));
                }
                case "failure-rate": {
                    int failureRate = this.properties.getOptionalInt(EXECUTION_RESTART_STRATEGY_MAX_FAILURES_PER_INTERVAL).orElseGet(() -> this.useDefaultValue(EXECUTION_RESTART_STRATEGY_MAX_FAILURES_PER_INTERVAL, 1));
                    long failureInterval = this.properties.getOptionalLong(EXECUTION_RESTART_STRATEGY_FAILURE_RATE_INTERVAL).orElseGet(() -> this.useDefaultValue(EXECUTION_RESTART_STRATEGY_FAILURE_RATE_INTERVAL, 60000L));
                    long attemptDelay = this.properties.getOptionalLong(EXECUTION_RESTART_STRATEGY_DELAY).orElseGet(() -> this.useDefaultValue(EXECUTION_RESTART_STRATEGY_DELAY, 10000L));
                    return Optional.of(RestartStrategies.failureRateRestart((int)failureRate, (Time)Time.milliseconds((long)failureInterval), (Time)Time.milliseconds((long)attemptDelay)));
                }
            }
            return Optional.empty();
        }).orElseGet(() -> this.useDefaultValue(EXECUTION_RESTART_STRATEGY_TYPE, RestartStrategies.fallBackRestart(), EXECUTION_RESTART_STRATEGY_TYPE_VALUE_FALLBACK));
    }

    public Optional<String> getCurrentCatalog() {
        return this.properties.getOptionalString(EXECUTION_CURRENT_CATALOG);
    }

    public Optional<String> getCurrentDatabase() {
        return this.properties.getOptionalString(EXECUTION_CURRENT_DATABASE);
    }

    public Map<String, String> asTopLevelMap() {
        return this.properties.asPrefixedMap("execution.");
    }

    private <V> V useDefaultValue(String key, V defaultValue) {
        return this.useDefaultValue(key, defaultValue, defaultValue.toString());
    }

    private <V> V useDefaultValue(String key, V defaultValue, String defaultString) {
        LOG.info("Property '{}.{}' not specified. Using default value: {}", new Object[]{"execution", key, defaultString});
        return defaultValue;
    }

    public static ExecutionEntry create(Map<String, Object> config) {
        return new ExecutionEntry(ConfigUtil.normalizeYaml(config));
    }

    public static ExecutionEntry merge(ExecutionEntry execution1, ExecutionEntry execution2) {
        HashMap mergedProperties = new HashMap(execution1.asMap());
        mergedProperties.putAll(execution2.asMap());
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(mergedProperties);
        return new ExecutionEntry(properties);
    }

    public static ExecutionEntry enrich(ExecutionEntry execution, Map<String, String> prefixedProperties) {
        HashMap enrichedProperties = new HashMap(execution.asMap());
        prefixedProperties.forEach((k, v) -> {
            String normalizedKey = k.toLowerCase();
            if (k.startsWith("execution.")) {
                enrichedProperties.put(normalizedKey.substring("execution".length() + 1), v);
            }
        });
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(enrichedProperties);
        return new ExecutionEntry(properties);
    }
}

