/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectResultBase;
import org.apache.flink.types.Row;

public class MaterializedCollectBatchResult
extends MaterializedCollectResultBase {
    @VisibleForTesting
    public MaterializedCollectBatchResult(TableResult tableResult, int maxRowCount, int overcommitThreshold) {
        super(tableResult, maxRowCount, overcommitThreshold);
        this.retrievalThread.start();
    }

    public MaterializedCollectBatchResult(TableResult tableResult, int maxRowCount) {
        this(tableResult, maxRowCount, MaterializedCollectBatchResult.computeMaterializedTableOvercommit(maxRowCount));
    }

    @VisibleForTesting
    protected List<Row> getMaterializedTable() {
        return this.materializedTable;
    }

    @Override
    protected void processRecord(Row row) {
        if (this.materializedTable.size() - this.validRowPosition >= this.maxRowCount) {
            this.cleanUp();
        }
        this.materializedTable.add(row);
    }

    private void cleanUp() {
        this.materializedTable.set(this.validRowPosition, null);
        ++this.validRowPosition;
        if (this.validRowPosition >= this.overcommitThreshold) {
            this.materializedTable.subList(0, this.validRowPosition).clear();
            this.validRowPosition = 0;
        }
    }
}

