/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectResultBase;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

public class MaterializedCollectStreamResult
extends MaterializedCollectResultBase {
    private final Map<Row, Integer> rowPositionCache;

    @VisibleForTesting
    public MaterializedCollectStreamResult(TableResult tableResult, int maxRowCount, int overcommitThreshold) {
        super(tableResult, maxRowCount, overcommitThreshold);
        int initialCapacity = MaterializedCollectStreamResult.computeMaterializedTableCapacity(maxRowCount);
        this.rowPositionCache = new HashMap<Row, Integer>(initialCapacity);
        this.retrievalThread.start();
    }

    public MaterializedCollectStreamResult(TableResult tableResult, int maxRowCount) {
        this(tableResult, maxRowCount, MaterializedCollectStreamResult.computeMaterializedTableOvercommit(maxRowCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRecord(Row row) {
        Object object = this.resultLock;
        synchronized (object) {
            boolean isInsertOp = row.getKind() == RowKind.INSERT || row.getKind() == RowKind.UPDATE_AFTER;
            row.setKind(RowKind.INSERT);
            if (isInsertOp) {
                this.processInsert(row);
            } else {
                this.processDelete(row);
            }
        }
    }

    @VisibleForTesting
    protected List<Row> getMaterializedTable() {
        return this.materializedTable;
    }

    private void processInsert(Row row) {
        if (this.materializedTable.size() - this.validRowPosition >= this.maxRowCount) {
            this.cleanUp();
        }
        this.materializedTable.add(row);
        this.rowPositionCache.put(row, this.materializedTable.size() - 1);
    }

    private void processDelete(Row row) {
        Integer cachedPos = this.rowPositionCache.get(row);
        int startSearchPos = cachedPos != null ? Math.min(cachedPos, this.materializedTable.size() - 1) : this.materializedTable.size() - 1;
        for (int i = startSearchPos; i >= this.validRowPosition; --i) {
            if (!((Row)this.materializedTable.get(i)).equals((Object)row)) continue;
            this.materializedTable.remove(i);
            this.rowPositionCache.remove(row);
            break;
        }
    }

    private void cleanUp() {
        Row deleteRow = (Row)this.materializedTable.get(this.validRowPosition);
        if (this.rowPositionCache.get(deleteRow) == this.validRowPosition) {
            this.rowPositionCache.remove(deleteRow);
        }
        this.materializedTable.set(this.validRowPosition, null);
        ++this.validRowPosition;
        if (this.validRowPosition >= this.overcommitThreshold) {
            this.materializedTable.subList(0, this.validRowPosition).clear();
            this.rowPositionCache.replaceAll((k, v) -> v - this.validRowPosition);
            this.validRowPosition = 0;
        }
    }
}

