/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class AggregateApplyAllWindowFunction<W extends Window, T, ACC, V, R>
extends WrappingFunction<AllWindowFunction<V, R, W>>
implements AllWindowFunction<T, R, W> {
    private static final long serialVersionUID = 1L;
    private final AggregateFunction<T, ACC, V> aggFunction;

    public AggregateApplyAllWindowFunction(AggregateFunction<T, ACC, V> aggFunction, AllWindowFunction<V, R, W> windowFunction) {
        super(windowFunction);
        this.aggFunction = aggFunction;
    }

    @Override
    public void apply(W window, Iterable<T> values, Collector<R> out) throws Exception {
        Object acc = this.aggFunction.createAccumulator();
        for (T value : values) {
            this.aggFunction.add(value, acc);
        }
        ((AllWindowFunction)this.wrappedFunction).apply(window, Collections.singletonList(this.aggFunction.getResult(acc)), out);
    }
}

