/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.evictors;

import java.util.Iterator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.shaded.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.TimestampedValue;

@PublicEvolving
public class DeltaEvictor<T, W extends Window>
implements Evictor<T, W> {
    private static final long serialVersionUID = 1L;
    DeltaFunction<T> deltaFunction;
    private double threshold;
    private final boolean doEvictAfter;

    private DeltaEvictor(double threshold, DeltaFunction<T> deltaFunction) {
        this.deltaFunction = deltaFunction;
        this.threshold = threshold;
        this.doEvictAfter = false;
    }

    private DeltaEvictor(double threshold, DeltaFunction<T> deltaFunction, boolean doEvictAfter) {
        this.deltaFunction = deltaFunction;
        this.threshold = threshold;
        this.doEvictAfter = doEvictAfter;
    }

    @Override
    public void evictBefore(Iterable<TimestampedValue<T>> elements, int size, W window, Evictor.EvictorContext ctx) {
        if (!this.doEvictAfter) {
            this.evict(elements, size, ctx);
        }
    }

    @Override
    public void evictAfter(Iterable<TimestampedValue<T>> elements, int size, W window, Evictor.EvictorContext ctx) {
        if (this.doEvictAfter) {
            this.evict(elements, size, ctx);
        }
    }

    private void evict(Iterable<TimestampedValue<T>> elements, int size, Evictor.EvictorContext ctx) {
        TimestampedValue<T> lastElement = Iterables.getLast(elements);
        Iterator<TimestampedValue<T>> iterator = elements.iterator();
        while (iterator.hasNext()) {
            TimestampedValue<T> element = iterator.next();
            if (!(this.deltaFunction.getDelta(element.getValue(), lastElement.getValue()) >= this.threshold)) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return "DeltaEvictor(" + this.deltaFunction + ", " + this.threshold + ")";
    }

    public static <T, W extends Window> DeltaEvictor<T, W> of(double threshold, DeltaFunction<T> deltaFunction) {
        return new DeltaEvictor<T, W>(threshold, deltaFunction);
    }

    public static <T, W extends Window> DeltaEvictor<T, W> of(double threshold, DeltaFunction<T> deltaFunction, boolean doEvictAfter) {
        return new DeltaEvictor<T, W>(threshold, deltaFunction, doEvictAfter);
    }
}

