/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public class StreamSink<IN>
extends AbstractUdfStreamOperator<Object, SinkFunction<IN>>
implements OneInputStreamOperator<IN, Object> {
    private static final long serialVersionUID = 1L;
    private transient SimpleContext sinkContext;
    private long currentWatermark = Long.MIN_VALUE;

    public StreamSink(SinkFunction<IN> sinkFunction) {
        super(sinkFunction);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.sinkContext = new SimpleContext(this.getProcessingTimeService());
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.sinkContext.element = element;
        ((SinkFunction)this.userFunction).invoke(element.getValue(), this.sinkContext);
    }

    @Override
    protected void reportOrForwardLatencyMarker(LatencyMarker marker) {
        this.latencyStats.reportLatency(marker);
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    private class SimpleContext<IN>
    implements SinkFunction.Context<IN> {
        private StreamRecord<IN> element;
        private final ProcessingTimeService processingTimeService;

        public SimpleContext(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        @Override
        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        @Override
        public long currentWatermark() {
            return StreamSink.this.currentWatermark;
        }

        @Override
        public Long timestamp() {
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }
    }
}

