/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.AbstractDataOutput;
import org.apache.flink.streaming.runtime.io.StreamOneInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskSourceInput;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class SourceOperatorStreamTask<T>
extends StreamTask<T, SourceOperator<T, ?>> {
    public SourceOperatorStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    public void init() {
        StreamTaskSourceInput input = new StreamTaskSourceInput((SourceOperator)this.headOperator);
        AsyncDataOutputToOutput output = new AsyncDataOutputToOutput(this.operatorChain.getChainEntryPoint(), this.getStreamStatusMaintainer());
        this.inputProcessor = new StreamOneInputProcessor(input, output, this.operatorChain);
    }

    private static class AsyncDataOutputToOutput<T>
    extends AbstractDataOutput<T> {
        private final Output<StreamRecord<T>> output;

        AsyncDataOutputToOutput(Output<StreamRecord<T>> output, StreamStatusMaintainer streamStatusMaintainer) {
            super(streamStatusMaintainer);
            this.output = (Output)Preconditions.checkNotNull(output);
        }

        @Override
        public void emitRecord(StreamRecord<T> streamRecord) {
            this.output.collect(streamRecord);
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            this.output.emitLatencyMarker(latencyMarker);
        }

        @Override
        public void emitWatermark(Watermark watermark) {
            this.output.emitWatermark(watermark);
        }
    }
}

