/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.StatisticsValidator;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;

@PublicEvolving
public class Statistics
implements Descriptor {
    private final DescriptorProperties internalProperties = new DescriptorProperties(true);
    private LinkedHashMap<String, Map<String, String>> columnStats = new LinkedHashMap();

    public Statistics tableStats(TableStats tableStats) {
        this.rowCount(tableStats.getRowCount());
        this.columnStats.clear();
        tableStats.getColumnStats().forEach(this::columnStats);
        return this;
    }

    public Statistics rowCount(long rowCount) {
        this.internalProperties.putLong("statistics.row-count", rowCount);
        return this;
    }

    public Statistics columnStats(String columnName, ColumnStats columnStats) {
        Map<String, String> map = StatisticsValidator.normalizeColumnStats(columnStats);
        this.columnStats.put(columnName, map);
        return this;
    }

    public Statistics columnDistinctCount(String columnName, Long ndv) {
        this.columnStats.computeIfAbsent(columnName, column -> new HashMap()).put("distinct-count", String.valueOf(ndv));
        return this;
    }

    public Statistics columnNullCount(String columnName, Long nullCount) {
        this.columnStats.computeIfAbsent(columnName, column -> new HashMap()).put("null-count", String.valueOf(nullCount));
        return this;
    }

    public Statistics columnAvgLength(String columnName, Double avgLen) {
        this.columnStats.computeIfAbsent(columnName, column -> new HashMap()).put("avg-length", String.valueOf(avgLen));
        return this;
    }

    public Statistics columnMaxLength(String columnName, Integer maxLen) {
        this.columnStats.computeIfAbsent(columnName, column -> new HashMap()).put("max-length", String.valueOf(maxLen));
        return this;
    }

    public Statistics columnMaxValue(String columnName, Number max) {
        this.columnStats.computeIfAbsent(columnName, column -> new HashMap()).put("max-value", String.valueOf(max));
        return this;
    }

    public Statistics columnMinValue(String columnName, Number min) {
        this.columnStats.computeIfAbsent(columnName, column -> new HashMap()).put("min-value", String.valueOf(min));
        return this;
    }

    @Override
    public final Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(this.internalProperties);
        properties.putInt("statistics.property-version", 1);
        ArrayList<Map<String, String>> namedStats = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : this.columnStats.entrySet()) {
            Map<String, String> columnStat = entry.getValue();
            columnStat.put("name", entry.getKey());
            namedStats.add(columnStat);
        }
        properties.putIndexedVariableProperties("statistics.columns", namedStats);
        return properties.asMap();
    }
}

