/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;

public class BigQuerySqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new BigQuerySqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.BIG_QUERY).withNullCollation(NullCollation.LOW));
    private static final SqlOperator UNION_DISTINCT = new SqlSetOperator("UNION DISTINCT", SqlKind.UNION, 14, false);
    private static final SqlSetOperator EXCEPT_DISTINCT = new SqlSetOperator("EXCEPT DISTINCT", SqlKind.EXCEPT, 14, false);
    private static final SqlSetOperator INTERSECT_DISTINCT = new SqlSetOperator("INTERSECT DISTINCT", SqlKind.INTERSECT, 18, false);

    public BigQuerySqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("STRPOS");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function STRPOS in Big Query");
                }
                writer.endFunCall(frame);
                break;
            }
            case UNION: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, UNION_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case EXCEPT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, EXCEPT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case INTERSECT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, INTERSECT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }
}

